% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_software.R
\name{plot_gtdb_tr}
\alias{plot_gtdb_tr}
\title{Plot GTDB-Tk Phylogenetic Tree with Taxonomic Coloring}
\usage{
plot_gtdb_tr(
  gtdb_res,
  tree,
  tax_level = "Phylum",
  represented = TRUE,
  layout = "fan",
  branch_size = 0.2,
  color_na = "black"
)
}
\arguments{
\item{gtdb_res}{A data frame containing GTDB-Tk classification results, typically
the output from \code{\link{pre_gtdb_tk}} function.}

\item{tree}{A phylogenetic tree object (phylo class) containing all genomes.}

\item{tax_level}{Character specifying the taxonomic level for coloring tips.
Default is "Phylum". Other options include "Class", "Order", "Family", "Genus", "Species".}

\item{represented}{Logical indicating whether to include only one representative genome
per species. Default is TRUE.}

\item{layout}{Character specifying the tree layout. Options include "fan", "circular",
"rectangular", etc. Default is "fan".}

\item{branch_size}{Numeric value for branch line width. Default is 0.2.}

\item{color_na}{Character specifying color for tips with missing taxonomic information.
Default is "black".}
}
\value{
A ggplot object containing the phylogenetic tree visualization.
}
\description{
This function creates a circular phylogenetic tree visualization from GTDB-Tk results,
with tips colored by specified taxonomic level. It can optionally represent only one genome per species.
}
