% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkGroups.R
\name{checkGroups}
\alias{checkGroups}
\title{Helper function to check groups in data.}
\usage{
checkGroups(df, group)
}
\arguments{
\item{df}{Data frame to use.}

\item{group}{Set of variables to use in grouping observations.
These taken together should identify a unique plant (or unique plant at a unique angle) across time.}
}
\value{
If there are duplicates in the grouping then this will return a message with code to start
checking the duplicates in your data.
}
\description{
Helper function to check groups in data.
}
\examples{

df <- growthSim("linear",
  n = 10, t = 10,
  params = list("A" = c(2, 1.5))
)
checkGroups(df, c("time", "id", "group"))
df$time[12] <- 3
checkGroups(df, c("time", "id", "group"))

}
