% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COLA.R
\name{make_patterns}
\alias{make_patterns}
\title{Construct binary covariate pattern matrix}
\usage{
make_patterns(x_names, intercept = TRUE)
}
\arguments{
\item{x_names}{Character vector of fixed-effect names. If `intercept = TRUE`,
it may include `"Intercept"`; otherwise it must not.}

\item{intercept}{Logical; include a fixed intercept column. Default: `TRUE`.}
}
\value{
A tibble of all binary patterns over `x_names` (with/without `Intercept`),
  one row per pattern.
}
\description{
Builds the full design grid of binary fixed-effect patterns used by COLA
to aggregate counts and outcome sums. When `intercept = TRUE`, an `Intercept`
column of ones is included and all other variables are expanded over \{0,1\}.
}
\keyword{internal}
