% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparePhenotypeData.R
\name{preparePhenotypeData}
\alias{preparePhenotypeData}
\title{Prepare phenotype data}
\usage{
preparePhenotypeData(phenotypeData)
}
\arguments{
\item{phenotypeData}{parsed phenotype data collection sheet returned from \code{readPhenotypeSheet}}
}
\description{
Process parsed phenotype data sheets into a tibble suitable for random forest analysis.
}
\examples{
library(dplyr)

## Retrieve file paths for example data
files <- list.files(system.file('phenotypeDataCollectionSheets',
  package = 'pdi'),full.names = TRUE)

## Prepare data
d <- map(files,readPhenotypeSheet) \%>\%
  map(preparePhenotypeData)
}
