% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwiseReversible.R
\name{maxRate}
\alias{maxRate}
\title{Upper limits for overall mutation rate for the stepwise reversible model.}
\usage{
maxRate(alleles, afreq, range)
}
\arguments{
\item{alleles}{A character vector with allele labels.}

\item{afreq}{A numeric vector of allele frequencies.}

\item{range}{A positive number.}
}
\value{
A vector of two numbers named \code{UW} and \code{UB}. The first of these is
the maximum overall mutation rate for a well-defined stepwise reversible
mutation matrix with the given input. The latter (UB) is the upper limit of
the overall mutation rate under the additional restraint that the model is
bounded by \code{afreq}.
}
\description{
Upper limits for overall mutation rate for the stepwise reversible model.
}
\author{
Thore Egeland.
}
