% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputHelpers.R
\name{printRejectionRates}
\alias{printRejectionRates}
\title{Print MCMC Rejection Rates}
\usage{
printRejectionRates(results, verbose = TRUE)
}
\arguments{
\item{results}{A list of MCMC chain results.}

\item{verbose}{Logical, whether to print rates to console. Default is TRUE.}
}
\value{
A named numeric vector containing the rejection rate (between 0 and 1) for each MCMC chain.
Names are of the form "Chain X" where X is the chain number.
}
\description{
Print MCMC Rejection Rates
}
\details{
Extracts and prints the rejection rates from MCMC chain results.
}
\examples{
# Create example results list with two chains
results <- list(
  list(rejection_rate = 0.3),
  list(rejection_rate = 0.4)
)

# Get rejection rates without printing
rates <- printRejectionRates(results, verbose = FALSE)

# Print rejection rates
rates <- printRejectionRates(results)

}
