% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docData.R
\docType{data}
\name{simulated_families}
\alias{simulated_families}
\title{Processed Family Data}
\format{
A list of processed family data.
}
\source{
Generated for package example
}
\usage{
simulated_families
}
\description{
A dataset containing processed information about the first simulated 130 families.
These families are referenced in the vigniette simulation_study.Rmd and using_penetrance.Rmd
The user must specify the \code{pedigree} argument as a data frame which contains the
family data (see \code{test_fam}). The family data must be in the correct format with the following columns:
}
\details{
\describe{
\item{\code{ID}}{A numeric value representing the unique identifier for each individual. There should be no duplicated entries.}
\item{\code{Sex}}{A numeric value where \code{0} indicates female and \code{1} indicates male. Missing entries are not currently supported.}
\item{\code{MotherID}}{A numeric value representing the unique identifier for an individual's mother.}
\item{\code{FatherID}}{A numeric value representing the unique identifier for an individual's father.}
\item{\code{isProband}}{A numeric value where \code{1} indicates the individual is a proband and \code{0} otherwise.}
\item{\code{CurAge}}{A numeric value indicating the age of censoring (current age if the person is alive or age at death if the person is deceased). Allowed ages range from \code{1} to \code{94}.}
\item{\code{isAff}}{A numeric value indicating the affection status of cancer, with \code{1} for diagnosed individuals and \code{0} otherwise. Missing entries are not supported.}
\item{\code{Age}}{A numeric value indicating the age of cancer diagnosis, encoded as \code{NA} if the individual was not diagnosed. Allowed ages range from \code{1} to \code{94}.}
\item{\code{Geno}}{A column for germline testing or tumor marker testing results. Positive results should be coded as \code{1}, negative results as \code{0}, and unknown results as \code{NA} or left empty.}
}
}
\keyword{datasets}
