% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_access.R
\name{pm_species}
\alias{pm_species}
\title{Filter mammal species from the Peruvian backbone}
\usage{
pm_species(
  order = NULL,
  family = NULL,
  genus = NULL,
  endemic = NULL,
  ecoregion = NULL
)
}
\arguments{
\item{order}{Optional character vector with one or more taxonomic orders
to keep. If \code{NULL} (default), no filter is applied by order.}

\item{family}{Optional character vector with one or more families to keep.
If \code{NULL} (default), no filter is applied by family.}

\item{genus}{Optional character vector with one or more genera to keep.
If \code{NULL} (default), no filter is applied by genus.}

\item{endemic}{Optional logical. If \code{TRUE}, only endemic species
are returned; if \code{FALSE}, only non-endemic species are returned;
if \code{NULL} (default), no filter is applied by endemism.}

\item{ecoregion}{Optional character vector with one or more ecoregion
codes (e.g. \code{"YUN"}, \code{"SB"}, \code{"COS"}). If supplied, only
species occurring in at least one of the given ecoregions are returned.}
}
\value{
A tibble with a subset of rows from \code{peru_mammals}.
}
\description{
Convenience wrapper around \code{peru_mammals} to subset species by
taxonomic group, endemism and/or ecoregion.
}
\examples{
# All species
pm_species()

# Only Rodentia
pm_species(order = "Rodentia")

# Endemic bats (Chiroptera)
pm_species(order = "Chiroptera", endemic = TRUE)

# Species present in Yungas (YUN) and Selva Baja (SB)
pm_species(ecoregion = c("YUN", "SB"))


}
