% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_creators.R
\name{createPFCPPTemplates}
\alias{createPFCPPTemplates}
\title{Create c++ template files for bootstrap filters (with or without covariates), 
auxiliary particle filters, sequential importance sampling with resampling 
filters, or Rao-Blackwellized/Marginal particle filters.}
\usage{
createPFCPPTemplates(modname, pfAlgo, fileDir, openNow = TRUE)
}
\arguments{
\item{modname}{name of model in all lowercase}

\item{pfAlgo}{Either "BSF", "APF", "BSWC", "SISR", "RBPFHMM", or "RBPFKALMAN"}

\item{fileDir}{where to save files. Not saved if NULL (but three files are returned in list).}

\item{openNow}{TRUE if you want to open this now in RStudio. Ignored if fileDir is NULL.}
}
\value{
NULL if saving files, otherwise a list with three character vectors
}
\description{
Create c++ template files for bootstrap filters (with or without covariates), 
auxiliary particle filters, sequential importance sampling with resampling 
filters, or Rao-Blackwellized/Marginal particle filters.
}
\examples{
# return in list of character strings
createPFCPPTemplates("coolmod", "BSF", fileDir = NULL)

\dontrun{
# save three files to Desktop, and
# begin editing them in rstudio IDE
createPFCPPTemplates("coolmod", "BSF", fileDir = "~/Desktop/")
}
}
