% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgdraw.R
\name{pgdraw.moments}
\alias{pgdraw.moments}
\title{Compute exact first and second moments for the Polya-Gamma distribution, PG(b, c)}
\usage{
pgdraw.moments(b, c)
}
\arguments{
\item{b}{The 'b' parameter of the Polya-Gamma distribution.}

\item{c}{The 'c' parameter of the Polya-Gamma distribution.}
}
\value{
A list containing the mean and variance.
}
\description{
Compute exact first and second moments for the Polya-Gamma distribution
}
\section{Details}{

This code computes the exact mean and variance of the Polya-Gamma distribution for the specified parameters.
}

\examples{
# -----------------------------------------------------------------
# Example: Simulated vs exact moments

u = matrix(1,1e6,1)
x = pgdraw(1,0.5*u)
mean(x)
var(x)
pgdraw.moments(1,0.5)

x = pgdraw(2,2*u)
mean(x)
var(x)
pgdraw.moments(2,2)


}
\references{
Jesse Bennett Windle
 Forecasting High-Dimensional, Time-Varying Variance-Covariance Matrices
 with High-Frequency Data and Sampling Polya-Gamma Random Variates for
 Posterior Distributions Derived from Logistic Likelihoods  
 PhD Thesis, 2013 
 
 Bayesian Inference for Logistic Models Using Polya-Gamma Latent Variables
 Nicholas G. Polson, James G. Scott and Jesse Windle
 Journal of the American Statistical Association
 Vol. 108, No. 504, pp. 1339--1349, 2013
}
\seealso{
\code{\link{pgdraw}}
}
