% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_estimation_step}
\alias{add_estimation_step}
\title{add_estimation_step}
\usage{
add_estimation_step(
  model,
  method,
  idx = NULL,
  interaction = FALSE,
  parameter_uncertainty_method = NULL,
  evaluation = FALSE,
  maximum_evaluations = NULL,
  laplace = FALSE,
  isample = NULL,
  niter = NULL,
  auto = NULL,
  keep_every_nth_iter = NULL,
  residuals = c(),
  predictions = c(),
  solver = NULL,
  solver_rtol = NULL,
  solver_atol = NULL,
  tool_options = {
 },
  derivatives = c(),
  individual_eta_samples = FALSE
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{method}{(str) estimation method to change to}

\item{idx}{(numeric (optional)) index of estimation step (starting from 0), default is NULL (adds step at the end)}

\item{interaction}{(logical) See :class:\code{~pharmpy.model.EstimationStep} for more information on options}

\item{parameter_uncertainty_method}{(str (optional)) See above}

\item{evaluation}{(logical) See above}

\item{maximum_evaluations}{(numeric (optional)) See above}

\item{laplace}{(logical) See above}

\item{isample}{(numeric (optional)) See above}

\item{niter}{(numeric (optional)) See above}

\item{auto}{(logical (optional)) See above}

\item{keep_every_nth_iter}{(numeric (optional)) See above}

\item{residuals}{(array(str)) See above}

\item{predictions}{(array(str)) See above}

\item{solver}{(str (optional)) See above}

\item{solver_rtol}{(numeric (optional)) See above}

\item{solver_atol}{(numeric (optional)) See above}

\item{tool_options}{(list(str=any)) See above}

\item{derivatives}{(array(array(Expr))) See above}

\item{individual_eta_samples}{(logical) See above}
}
\value{
(Model) Pharmpy model object
}
\description{
Add estimation step

Adds estimation step for a model in a given index. Methods currently supported are:
FO, FOCE, ITS, LAPLACE, IMPMAP, IMP, SAEM
}
\examples{
\dontrun{
model <- load_example_model("pheno")
opts <- list('NITER'=1000, 'ISAMPLE'=100)
model <- add_estimation_step(model, 'IMP', tool_options=opts)
ests <- model$execution_steps
length(ests)
ests[2]
}
}
\seealso{
set_estimation_step

remove_estimation_step

append_estimation_step_options

add_parameter_uncertainty_step

remove_parameter_uncertainty_step

set_evaluation_step
}
