% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_peripheral_compartments}
\alias{set_peripheral_compartments}
\title{set_peripheral_compartments}
\usage{
set_peripheral_compartments(model, n, name = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{n}{(numeric) Number of transit compartments}

\item{name}{(str (optional)) Name of compartment to add peripheral to.}
}
\value{
(Model) Pharmpy model object
}
\description{
Sets the number of peripheral compartments for central compartment to a specified number.

If name is set, the peripheral compartment will be added to the compartment
with the specified name instead.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_peripheral_compartments(model, 2)
model$statements$ode_system
}
}
\seealso{
add_peripheral_compartment

remove_peripheral_compartment
}
