% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunPRMD.R
\name{RunPRMD}
\alias{RunPRMD}
\title{Implement a Multi-Stage Phase I Dose-Finding Design to recommend dosage
selection based on the data collected in the available patient cohorts}
\usage{
RunPRMD(
  seed = 1234,
  patlist,
  patID_act = NULL,
  cycle_act = NULL,
  dose_act = NULL,
  dlt_act = NULL,
  doses = 1:6,
  cycles = 1:6,
  tox.target = 0.28,
  p_tox1 = 0.2,
  p_tox2 = 0.2,
  trialSize = 36,
  chSize = 3,
  thrd1 = 0.28,
  thrd2 = 0.28,
  proxy.thrd = 0.1,
  param.ctrl = list(),
  n.iters = 10000,
  burn.in = 5000,
  thin = 2,
  n.chains = 1,
  effcy.flag = T,
  ICD.flag = T,
  DLT.drop.flag = T,
  testedD = T,
  IED.flag = T,
  ICD_thrd = 0.3
)
}
\arguments{
\item{seed}{The seed of R's random number generator. Default is 1234}

\item{patlist}{A list of the patient treatment records, which must contains
  the following variables:

  \describe{ \item{PatID}{denotes the patient ID where the elements are
  specified by cohort and subject number. For example, "cohort2subject3"
  denotes the third subject in the second cohort}

  \item{dose}{records the dose level assigned for each patient through the
  whole treatment}

  \item{cycle}{shows the treatment cycle information of each record}

  \item{nTTP}{records the corresponding nTTP score.}

  \item{dlt}{indicates whether a DLT event is observed or not?}

  \item{efficacy}{provides the continuous efficacy for each cycle. Required
  when \code{effcy.flag == T}. The range of efficacy is (0, 1), use -1 for
  missing efficacy response.} } See \code{\link{patlist_sim}} for an
  example.}

\item{patID_act}{A vector recording the patients' ID who need dose
recommendation for next cycle. Default is \code{NULL}}

\item{cycle_act}{A vector recording the current cycle of patID_act. Default
is \code{NULL}}

\item{dose_act}{A vector recording the current dose level of patID_act.
Default is \code{NULL}}

\item{dlt_act}{A vector indicating whether a dlt is observed in current
cycle for current patients. Default is \code{NULL}}

\item{doses}{A vector of doses that users are going to explore. Default is
1:6, where dose 1 through dose 6 are being tested.}

\item{cycles}{A vector of cycles that the treatment plans to go through.
Default is 1:6, where patients will experience up to 6 cycles of the
treatment}

\item{tox.target}{The target toxicity of the treatment. Default is 0.28.
See details below.}

\item{p_tox1}{The probability cutoff for cycle 1 toxicity. Default is 0.2.
See details below.}

\item{p_tox2}{The probability cutoff for later cycles toxicity beyond
cycle 1. Default is 0.2. See Details below.}

\item{trialSize}{The maximum sample size for trial simulation. Default is
36. Must be the multiple of cohort size (\code{chSize}).}

\item{chSize}{The cohort size of patients recruited. Default is 3.}

\item{thrd1}{An upper bound of toxicity for cycle 1 of the treatment.
Default is 0.28. See Details below.}

\item{thrd2}{An upper bound of toxicity for late cycles of the treatment,
beyond cycle 1. Default is 0.28. See Details below}

\item{proxy.thrd}{A distance parameter to define efficacious doses. Any
dose whose predicted efficacy is within proxy.thrd away from the largest
one among the safe doses will be declared an efficacious dose.}

\item{param.ctrl}{A list specifying the prior distribution for the
  parameters. \describe{\item{p1_beta_intercept}{the prior mean of
  intercept of toxicity model assuming a normal prior}

  \item{p2_beta_intercept}{the precision (inverse of variance) of intercept
  of toxicity model assuming a normal prior}

  \item{p1_beta_cycle}{the prior mean of cycle effect of toxicity model
  assuming a normal prior}

  \item{p2_beta_cycle}{the precision (inverse of variance) of cycle effect
  of toxicity model assuming a normal prior}

  \item{p1_beta_dose}{the prior minimum of dose effect of toxicity model
  assuming a uniform prior}

  \item{p2_beta_dose}{the prior maximum of dose effect of toxicity model
  assuming a uniform prior}

  \item{p1_alpha}{the prior mean vector of the parameters from efficacy
  model assuming a multivariate normal prior}

  \item{p2_alpha}{the prior precision matrix (inverse of covariance matrix)
  of the parameters from efficacy model assuming a multivariate normal
  prior}

  \item{p1_gamma0}{the prior mean of association parameter \eqn{\gamma}
  (See Du et al(2017)) of two submodels of the joint model assuming a
  normal prior}

  \item{p2_gamma0}{the prior precision (inverse of variance) of association
  parameter \eqn{\gamma} of two submodels of the joint model assuming a
  normal prior. } Default is non-informative priors. }}

\item{n.iters}{Total number of MCMC simulations. Default is 10,000.}

\item{burn.in}{Number of burn=ins in the MCMC simulation. Default is 5,000.}

\item{thin}{Thinning parameter. Default is 2.}

\item{n.chains}{No. of MCMC chains in Bayesian model fitting. Default is
1. Will check the convergence of MCMC chains by the potential scale
reduction factor (PSRF) when \code{n.chains} > 1.}

\item{effcy.flag}{Whether efficacy data is modeled in the model fitting or
not. Default is TRUE.}

\item{ICD.flag}{Whether we allow individualized dose modification in stage
1 model or not? Default is TRUE. See details below}

\item{DLT.drop.flag}{Whether the patients should suspend the treatment when
observing DLT. Default is TRUE.}

\item{testedD}{Default is TRUE. Whether we only allow ICD or IED to be less
than or equal to the maximum dose tested in first cycle.}

\item{IED.flag}{Default is TRUE. Whether we allow dose changing for cycle >
1 in stage 2 model or not?}

\item{ICD_thrd}{The cut-off point of the posterior toxicity probability in
defining ICD. Default is 0.3. See details below.}
}
\value{
\item{patlist}{The input data \code{patlist}} \item{doseA}{The
  recommended dose level for cycle 1 for new cohorts} \item{pat_rec}{The
  recommended dose for current patients for next cycle}
  \item{effcy.flag}{The input argument \code{effcy.flag}} \item{doses}{The
  input argument \code{doses}} \item{cycles}{The input argument
  \code{cycles}}
}
\description{
A function to implement a Multi-Stage Phase I Dose-Finding Design to
recommend dosage selection based on the data collected in the available
patient cohorts. The available models include 1-stage model with/without
individualized dose modification, 3-stage model with/without individualized
dose modification, 3-stage model with individualized dose modification on
stage II and 3-stage model with individualized dose modification on stage I
and dose modification on stage II.
}
\details{
The RunPRMD function implement a Multi-Stage Phase I Dose--Finding
  Design to recommend dosage selection based on the data collected in the
  available patient cohorts. The function will automatically identify the
  model and the stage based on all flags and the records. For the details
  of argument \code{tox.target}, \code{p_tox1}, \code{p_tox2}, \code{thrd1},
  \code{thrd2} and \code{ICD_thrd}, please check the help document of
  \code{\link{SimPRMD}}.
}
\examples{
data("patlist_sim")
# check the whole dataset by function patlist.display
patlist.display(patlist_sim, n.dose = 6, n.cycle = 6)

# When we pick the records before 6th cohort enrolled in the study
L <- length(patlist_sim$PatID)
patlist <- lapply(patlist_sim, function(a){a <- a[-(44:L)]})
patlist.display(patlist, n.dose = 6, n.cycle = 6)

#The table shows the current patient in the trial. Now record the active
#patient ID and records as follows

patID_act <- c("cohort1subject1", "cohort1subject2", "cohort1subject3",
               "cohort2subject1", "cohort2subject2", "cohort2subject3",
               "cohort3subject2", "cohort3subject3",
               "cohort4subject1", "cohort4subject2", "cohort4subject3",
               "cohort5subject1", "cohort5subject2", "cohort5subject3")
cycle_act <- c(5, 5, 5, 4, 4, 4, 3, 3, 2, 2, 2, 1, 1 ,1)
dose_act <- c(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4)
dlt_act <- c(0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0)

\donttest{
test <- RunPRMD(patlist = patlist, patID_act = patID_act,
                cycle_act = cycle_act, dose_act = dose_act,
                dlt_act = dlt_act, trialSize = 36, chSize = 3,
                effcy.flag = TRUE, ICD.flag = TRUE, DLT.drop.flag = TRUE,
                IED.flag = TRUE, ICD_thrd = 0.3)

summary(test)
plot(test)
plot(test, select_cycle = 1:2)
}

}
