% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_mcmc_p.R
\name{Tagloss_mcmc_p}
\alias{Tagloss_mcmc_p}
\title{Generates set of parameters to be used with Tagloss_mcmc()}
\usage{
Tagloss_mcmc_p(
  result = stop("An output from Tagloss_fit() must be provided"),
  default.density = "dunif",
  accept = FALSE
)
}
\arguments{
\item{result}{An object obtained after a Tagloss_fit() fit}

\item{default.density}{The default density, "dnorm" or "dunif'}

\item{accept}{If TRUE, does not wait for use interaction}
}
\value{
A matrix with the parameters
}
\description{
Interactive (or not!) script used to generate set of parameters to be used with Tagloss_mcmc().
}
\details{
Tagloss_mcmc_p generates set of parameters to be used with Tagloss_mcmc()
}
\examples{
\dontrun{
library(phenology)
# Example
data_f_21 <- Tagloss_format(outLR, model="21")

# model fitted by Rivalan et al. 2005
par <- c(a0_2=-5.43E-2, a1_2=-103.52, a4_2=5.62E-4, 
         delta_1=3.2E-4)
pfixed <- c(a2_2=0, a3_2=0, a2_1=0, a3_1=0)
model_before <- "par['a0_1']=par['a0_2'];par['a1_1']=par['a1_2'];par['a4_1']=par['a4_2']"
o <- Tagloss_fit(data=data_f_21, fitted.parameters=par, fixed.parameters=pfixed, 
                 model_before=model_before)
pMCMC <- Tagloss_mcmc_p(o, accept=TRUE)
o_MCMC <- Tagloss_mcmc(data=data_f_21, parameters=pMCMC, fixed.parameters=pfixed, 
                 model_before=model_before, 
                 n.iter=10000, n.chains = 1, n.adapt = 100, thin=30)
}
}
\seealso{
Other Model of Tag-loss: 
\code{\link{Tagloss_L}()},
\code{\link{Tagloss_LengthObs}()},
\code{\link{Tagloss_cumul}()},
\code{\link{Tagloss_daymax}()},
\code{\link{Tagloss_fit}()},
\code{\link{Tagloss_format}()},
\code{\link{Tagloss_mcmc}()},
\code{\link{Tagloss_model}()},
\code{\link{Tagloss_simulate}()},
\code{\link{logLik.Tagloss}()},
\code{\link{o_4p_p1p2}},
\code{\link{plot.Tagloss}()},
\code{\link{plot.TaglossData}()}
}
\author{
Marc Girondot
}
\concept{Model of Tag-loss}
