% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\docType{data}
\name{diseaseDxIcdMap}
\alias{diseaseDxIcdMap}
\title{Mapping of diseases and diagnostic ICD codes}
\format{
A data.table with the following columns:
\itemize{
\item \code{disease_id}: Numeric vector of OMIM disease identifiers
\item \code{disease_name}: Character vector of disease names
\item \code{icd}: Character vector of ICD codes indicating a genetic diagnosis
\item \code{flag}: Integer vector of the vocabulary of the ICD code
(\strong{9}: ICD-9-CM,  \strong{10}: ICD-10-CM)
\item \code{icd_name}: Character vector containing the description of each ICD code
}
}
\usage{
diseaseDxIcdMap
}
\description{
This table provides a mapping between 27 Mendelian diseases and the
corresponding ICD-9 and ICD-10 codes that indicate a genetic diagnosis.
}
\seealso{
\code{\link[=getPhecodeOccurrences]{getPhecodeOccurrences()}}, \code{\link[=getDxStatus]{getDxStatus()}}
}
\keyword{datasets}
