% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.integrate.r
\name{interpolate_wl}
\alias{interpolate_wl}
\alias{interpolate_wl.default}
\alias{interpolate_wl.generic_spct}
\alias{interpolate_wl.generic_mspct}
\title{Map spectra to new wavelength values.}
\usage{
interpolate_wl(x, w.length.out, fill, length.out, method, ...)

\method{interpolate_wl}{default}(x, w.length.out, fill, length.out, method, ...)

\method{interpolate_wl}{generic_spct}(
  x,
  w.length.out = NULL,
  fill = NA,
  length.out = NULL,
  method = "approx",
  ...
)

\method{interpolate_wl}{generic_mspct}(
  x,
  w.length.out = NULL,
  fill = NA,
  length.out = NULL,
  method = "approx",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object}

\item{w.length.out}{numeric vector of wavelengths (nm).}

\item{fill}{a numeric value to be assigned to out of range wavelengths.}

\item{length.out}{integer Length of the wavelength vector in the returned
value. Overrides \code{w.length.out} is not \code{NULL}, respects its
range but overrides the actual values.}

\item{method}{character string One of \code{"auto"}, \code{"approx"},
\code{"spline"}, \code{"skip"}.}

\item{...}{additional arguments passed to \code{spline()}.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A new spectral object or collection of spectral objects, of the same
  class as argument \code{x}. Each spectrum returned with more or fewer rows
  than in \code{x}, the requested new \code{w.length} values and new numeric
  values for spectral quantities, obtained by interpolation.
}
\description{
This method returns the result of interpolating spectral data from the
original set of wavelengths to a new one.
}
\details{
Depending on \code{method} natural spline interpolation or linear
  interpolation are used. With \code{method = spline} a call to
  \code{\link[stats:splinefun]{spline}} with \code{method = "natural"} is
  used and with \code{method = "approx"} a call to
  \code{\link[stats:approxfun]{approx}} is used. If \code{method = "auto"} or
  \code{method = NULL} when 100 or fewer distinct wavelengths are available
  as input and/or the maximum wavelength step size in \code{w.length.in} is
  more than three times the minimum wavelength step size in
  \code{w.length.out} \code{"spline"} is used and \code{"approx"} otherwise.
  Finally, with \code{method = "skip"} the input is returned unchanged.

  If \code{w.length.out} is a numeric vector and \code{length.out = NULL}, it
  directly gives the target wavelengths for interpolation. If it is
  \code{NULL}, and \code{length.out} is an integer value evenly spaced
  wavelength values covering the same wavelength range as in the input are
  generated. If \code{w.length.out} is a numeric vector and \code{length.out}
  is an integer value, \code{length.out} evenly spaced wavelengths covering
  the wavelength range of \code{w.length.out} are generated.
  \emph{Extrapolation is not supported.}

  With default \code{fill = NA} if the output exceeds the wavelength range of
  the input, extrapolated values are filled with \code{NA} values. With
  \code{fill = NULL} wavelengths outside the wavelength range of input data
  are discarded. A numerical value can be also be provided as fill. While
  \code{interpolate_spectrum} supports interpolation of a single numeric
  vector, \code{interpolate_wl} applies, one at a time, interpolation to all
  numeric columns found in \code{x}.
}
\section{Methods (by class)}{
\itemize{
\item \code{interpolate_wl(default)}: Default for generic function

\item \code{interpolate_wl(generic_spct)}: Interpolate wavelength in an object of class
"generic_spct" or derived.

\item \code{interpolate_wl(generic_mspct)}: Interpolate wavelength in an object of class
"generic_mspct" or derived.

}}
\examples{
interpolate_wl(sun.spct, 400:500, NA)
interpolate_wl(sun.spct, 400:500, NULL)
interpolate_wl(sun.spct, seq(200, 1000, by=0.1), 0)
interpolate_wl(sun.spct, c(400,500), length.out=201)

}
\concept{interpolate functions}
