% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{spct_metadata}
\alias{spct_metadata}
\title{Access metadata}
\usage{
spct_metadata(
  x,
  col.names = NULL,
  idx = "spct.idx",
  na.rm = is.null(col.names),
  unnest = TRUE
)
}
\arguments{
\item{x}{generic_mspct or generic_spct Any collection of spectra or spectrum.}

\item{col.names}{named character vector Name(s) of column(s) to create.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{na.rm}{logical Flag controlling deletion of columns containing only NA
values.}

\item{unnest}{logical Flag controlling if metadata attributes that are lists
of values should be returned in a list column or in separate columns.}
}
\value{
A \code{data.frame} or a \code{tibble} With the metadata attributes
  in separate new variables.
}
\description{
Return metadata attributes from a single spectrum or a collection of spectra
as a \code{data.frame}. A wrapper on \code{add_attr2tb} providing an
alternative order of formal parameters and constrained functionality.
}
\details{
Each attribute is by default copied to a column in a \code{tibble}
  or a \code{data.frame}. If the argument for \code{tb} is \code{NULL}, as by
  default, a new \code{tibble} will be created. If an existing
  \code{data.frame} or \code{tibble} is passed as argument, new columns are
  added to it. However, the number of rows in the argument passed to
  \code{tb} must match the number of spectra in the argument passed to
  \code{mspct}. Only in the case of methods \code{add_attr2tb()} and
  \code{spct_metadata()} if the argument to \code{col.names} is a named
  vector, the names of members are used as names for the columns created.
  This permits setting any valid name for the new columns. If the members of
  the vector passed to \code{col.names} have no names, then the value is
  interpreted as the name of the attributes to add, and also used as name for
  the new column.

  Valid values accepted as argument to \code{col.names} are \code{NULL}, or a
  vector containing one or more of the following \code{character} strings:
  \code{"lon"}, \code{"lat"}, \code{"address"}, \code{"geocode"},
  \code{"where.measured"}, \code{"when.measured"}, \code{"what.measured"},
  \code{"how.measured"}, \code{"comment"}, \code{"normalised"},
  \code{"normalized"}, \code{"scaled"}, \code{"bswf.used"},
  \code{"instr.desc"}, \code{"instr.sn"}, \code{solute.properties},
  \code{"filter.properties"}, \code{"Tfr.type"}, \code{"Rfr.type"},
  \code{"time.unit"}, \code{bswf.used}, \code{multiple.wl}. Invalid character
  values are ignored with a warning.
}
\note{
The order of the first two arguments is reversed in
  \code{add_attr2tb()}, \code{when_measured2tb()}, \code{what_measured2tb()},
  etc., compared to attribute query functions, such as \code{spct_metadata},
  \code{when_measured()}, \code{what_measured()}, \code{how_measured()}, etc.
  This is to allow the use of \code{add_attr2tb()} and related functions in
  'pipes' to add metadata to summaries computed at earlier steps in the pipe.
}
\examples{
# collection of spectra
spct_metadata(sun_evening.mspct)

spct_metadata(sun_evening.mspct, na.rm = FALSE)

spct_metadata(sun_evening.mspct,
              col.names = "geocode",
              unnest = FALSE)

spct_metadata(sun_evening.mspct,
              col.names = c(when.measured = "time", "what.measured"))

# multiple spectra in long form
spct_metadata(sun_evening.spct,
              col.names = c("geocode", "when.measured"))

# single spectrum
spct_metadata(sun.spct,
              col.names = c("geocode", "when.measured"))

}
\seealso{
\code{\link{add_attr2tb}} for more details.

Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
