% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photon_local.R
\name{photon_local}
\alias{photon_local}
\title{Local photon instance}
\value{
A list containing four elements:
\itemize{
\strong{status}: Shows \code{"Ok"} when photon is running without problems.
\strong{import_date}: Time stamp when the database was built.
\strong{version}: Photon version currently running.
\strong{git_commit}: Git commit string of the photon version currently running.
}
}
\description{
This R6 class is used to initialize and manage local photon instances.
It can download and setup the Java, the photon executable, and the necessary
OpenSearch index. It can start, stop, and query the status of the
photon instance. It is also the basis for geocoding requests as it is used
to retrieve the URL for geocoding.
}
\section{Search indices}{

Search indices can be self-provided by importing an existing
Nominatim database or they can be downloaded from the
\href{https://nominatim.org/2020/10/21/photon-country-extracts.html}{Photon download server}.
If you want to download pre-built search indices, simply provide a
\code{region} string during initialization or use the
\code{$download_data} method. Pre-built search indices do not come with
support for structured geocoding.

If you want to build from Nominatim, do not
provide a region string and use the \code{$import()} method. See
\code{vignette("nominatim-import", package = "photon")} for details on how
to import from Nominatim.

To enable structured geocoding, the photon geocoder needs to be built to
support OpenSearch. Since photon 0.7.0, OpenSearch jar files are the
standard and ElasticSearch is deprecated.
}

\examples{
\dontshow{if (getFromNamespace("is_online", "photon")("graphhopper.com") && getFromNamespace("photon_run_examples", "photon")()) withAutoprint(\{ # examplesIf}
if (has_java("11")) {
dir <- file.path(tempdir(), "photon")

# start a new instance using a Monaco extract
photon <- new_photon(path = dir, region = "Andorra")

# start a new instance with an older photon version
photon <- new_photon(path = dir, photon_version = "0.4.1", opensearch = FALSE)
}

\dontrun{
# import a nominatim database using OpenSearch photon
# this example requires the OpenSearch version of photon and a running
# Nominatim server.
photon <- new_photon(path = dir, opensearch = TRUE)
photon$import(photon_options = cmd_options(port = 29146, password = "pgpass"))}

photon$purge(ask = FALSE)
\dontshow{\}) # examplesIf}
}
\section{Super class}{
\code{\link[photon:photon]{photon::photon}} -> \code{photon_local}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{path}}{Path to the directory where the photon instance is stored.}

\item{\code{proc}}{\code{\link[processx]{process}} object that handles the
external process running photon.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-photon_local-new}{\code{photon_local$new()}}
\item \href{#method-photon_local-mount}{\code{photon_local$mount()}}
\item \href{#method-photon_local-info}{\code{photon_local$info()}}
\item \href{#method-photon_local-help}{\code{photon_local$help()}}
\item \href{#method-photon_local-purge}{\code{photon_local$purge()}}
\item \href{#method-photon_local-import}{\code{photon_local$import()}}
\item \href{#method-photon_local-start}{\code{photon_local$start()}}
\item \href{#method-photon_local-stop}{\code{photon_local$stop()}}
\item \href{#method-photon_local-status}{\code{photon_local$status()}}
\item \href{#method-photon_local-download_data}{\code{photon_local$download_data()}}
\item \href{#method-photon_local-remove_data}{\code{photon_local$remove_data()}}
\item \href{#method-photon_local-is_running}{\code{photon_local$is_running()}}
\item \href{#method-photon_local-is_ready}{\code{photon_local$is_ready()}}
\item \href{#method-photon_local-get_url}{\code{photon_local$get_url()}}
\item \href{#method-photon_local-get_logs}{\code{photon_local$get_logs()}}
\item \href{#method-photon_local-clone}{\code{photon_local$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-new"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-new}{}}}
\subsection{Method \code{new()}}{
Initialize a local photon instance. If necessary, downloads the photon
executable, the search index, and Java.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$new(
  path,
  photon_version = NULL,
  region = NULL,
  opensearch = TRUE,
  mount = TRUE,
  overwrite = FALSE,
  quiet = FALSE,
  country = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to a directory where the photon executable and data
should be stored.}

\item{\code{photon_version}}{Version of photon to be used. A list of all
releases can be found here: \url{https://github.com/komoot/photon/releases/}.
Ignored if \code{jar} is given. If \code{NULL}, uses the latest known
version (Currently: 1.0.0).}

\item{\code{region}}{Character string that identifies a region or country. An
extract for this region will be downloaded. If \code{"planet"}, downloads
a global extract (see note). Run \code{list_regions()} to get an overview
of available regions. You can specify countries using any code that can
be translated by \code{\link[countrycode]{countrycode}}.}

\item{\code{opensearch}}{Deprecated for photon versions >= 1.0.0 and superseded
for photon versions >= 0.7.0. If \code{TRUE},
attempts to download the OpenSearch version of photon. OpenSearch-based
photon supports structured geocoding. If \code{FALSE}, falls back to
ElasticSearch. Since photon 0.7.0, OpenSearch is the default and since
1.0.0, ElasticSearch is not supported anymore.}

\item{\code{mount}}{If \code{TRUE}, mounts the object to the session so that
functions like \code{\link{geocode}} automatically detect the new
instance. If \code{FALSE}, initializies the instance but doesn't mount
it to the session. Defaults to \code{TRUE}.}

\item{\code{overwrite}}{If \code{TRUE}, overwrites existing jar files and
search indices when initializing a new instance. Defaults to
\code{FALSE}.}

\item{\code{quiet}}{If \code{TRUE}, suppresses all informative messages.}

\item{\code{country}}{Deprecated since photon 1.0.0. Use \code{region} instead.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-mount"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-mount}{}}}
\subsection{Method \code{mount()}}{
Attach the object to the session. If mounted, all geocoding functions
send their requests to the URL of this instance. Manually mounting
is useful if you want to switch between multiple photon instances.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$mount()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-info"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-info}{}}}
\subsection{Method \code{info()}}{
Retrieve metadata about the java and photon version used as well
as the region and creation date of the search index.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing the java version, the photon version, and
if applicable, the spatial and temporal coverage of the search index.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-help"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-help}{}}}
\subsection{Method \code{help()}}{
Print the default arguments to the R console. This can be helpful to
get a list of additional photon arguments for \code{$start()} or
\code{$import()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$help(cmd = "start")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cmd}}{A command for which to display the help page. Must be one
of \code{"start"}, \code{"import"}, \code{"update"}, \code{"update-init"},
or \code{"dump-nominatim-db"}. Defaults to \code{"start"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, but prints to the console.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-purge"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-purge}{}}}
\subsection{Method \code{purge()}}{
Kill the photon process and remove the directory. Useful to get rid
of an instance entirely.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$purge(ask = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ask}}{If \code{TRUE}, asks for confirmation before purging the
instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-import"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-import}{}}}
\subsection{Method \code{import()}}{
Import a Postgres Nominatim database to photon. Runs the photon jar
file using the additional parameter \code{-nominatim-import}. Requires
a running Nominatim database that can be connected to.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$import(
  host = "127.0.0.1",
  port = 5432,
  database = "nominatim",
  user = "nominatim",
  password = "",
  json = FALSE,
  languages = c("en", "fr", "de", "it"),
  countries = NULL,
  full_geometries = FALSE,
  extra_tags = NULL,
  timeout = 60,
  java_opts = NULL,
  photon_opts = NULL,
  structured = NULL,
  update = NULL,
  enable_update_api = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Postgres host of the database. Defaults to \code{"127.0.0.1"}.}

\item{\code{port}}{Postgres port of the database. Defaults to \code{5432}.}

\item{\code{database}}{Postgres database name. Defaults to \code{"nominatim"}.}

\item{\code{user}}{Postgres database user. Defaults to \code{"nominatim"}.}

\item{\code{password}}{Postgres database password. Defaults to \code{""}.}

\item{\code{json}}{If \code{TRUE} and a JSON dump is present in the photon
directory, imports from a JSON dump. Otherwise, tries to import from
Nominatim.}

\item{\code{languages}}{Character vector specifying the languages to import
from the Nominatim databases. Defaults to English, French, German,
and Italian.}

\item{\code{countries}}{Character vector specifying the country codes to
import from the Nominatim database. Defaults to all country codes.}

\item{\code{full_geometries}}{Add the full geometry for each place if
available. Considerably increases the size of the photon database.}

\item{\code{extra_tags}}{Character vector specifying extra OSM tags to import
from the Nominatim database. These tags are used to augment geocoding
results. Defaults to \code{NULL}.}

\item{\code{timeout}}{Time in seconds before the java process aborts. Defaults
to 60 seconds.}

\item{\code{java_opts}}{Character vector of further flags passed on to the
\code{java} command.}

\item{\code{photon_opts}}{Character vector of further flags passed on to the
photon jar in the java command. See \code{\link{cmd_options}} for a
helper function.}

\item{\code{structured}}{Deprecated since v1.0.0. Structured geocoding is
enabled by default now. For earlier versions, use \code{photon_opts}.}

\item{\code{update}}{Deprecated since v1.0.0. Updates are done using a distinct
command now. For earlier versions, use \code{photon_opts}.}

\item{\code{enable_update_api}}{Deprecated since v1.0.0. For earlier versions,
use \code{photon_opts}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-start"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-start}{}}}
\subsection{Method \code{start()}}{
Start a local instance of the Photon geocoder. Runs the jar executable
located in the instance directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$start(
  host = "0.0.0.0",
  port = "2322",
  ssl = FALSE,
  timeout = 60,
  countries = NULL,
  threads = 1,
  query_timeout = NULL,
  max_results = NULL,
  max_reverse_results = NULL,
  java_opts = NULL,
  photon_opts = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Character string of the host name that the geocoder should
be opened on.}

\item{\code{port}}{Port that the geocoder should listen to.}

\item{\code{ssl}}{If \code{TRUE}, uses \code{https}, otherwise \code{http}.
Defaults to \code{FALSE}.}

\item{\code{timeout}}{Time in seconds before the java process aborts. Defaults
to 60 seconds.}

\item{\code{countries}}{Character vector of countries to import. By default,
all countries in the database are imported.}

\item{\code{threads}}{Number of threads in parallel. Defaults to 1.}

\item{\code{query_timeout}}{Time in seconds after which to cancel queries
to Photon. Defaults to 7 seconds.}

\item{\code{max_results}}{Maximum number of results returned to
\code{\link{geocode}} and \code{\link{structured}}. Defaults to
50.}

\item{\code{max_reverse_results}}{Maximum number of results returned to
\code{\link{reverse}}. Defaults to 50.}

\item{\code{java_opts}}{Character vector of further flags passed on to the
\code{java} command.}

\item{\code{photon_opts}}{Character vector of further flags passed on to the
photon jar in the java command. See \code{\link{cmd_options}} for a
helper function.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
While there is a certain way to determine if a photon instance is
ready, there is no clear way as of yet to determine if a photon setup
has failed. Due to this, a failing setup may sometimes hang instead of
emitting an error. In this case, please open a bug report.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-stop"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-stop}{}}}
\subsection{Method \code{stop()}}{
Kills the running photon process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-status"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-status}{}}}
\subsection{Method \code{status()}}{
Returns information from a live server about the photon version used
and the date of data import.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-download_data"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-download_data}{}}}
\subsection{Method \code{download_data()}}{
Downloads a search index using \code{\link{download_database}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$download_data(region, json = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{region}}{Character string that identifies a region or country. An
extract for this region will be downloaded. If \code{"planet"}, downloads
a global extract (see note). Run \code{list_regions()} to get an overview
of available regions. You can specify countries using any code that can
be translated by \code{\link[countrycode]{countrycode}}.}

\item{\code{json}}{Extracts come in two forms: JSON dumps and pre-build databases.
Pre-built databases are more convenient but less flexible and are not available
for all regions. If you wish or need to build your own database, set
\code{json = TRUE} and use the \code{$import()} method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-remove_data"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-remove_data}{}}}
\subsection{Method \code{remove_data()}}{
Removes the data currently used in the photon directory. This only
affects the unpacked \code{photon_data} directory, not archived files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$remove_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-is_running"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-is_running}{}}}
\subsection{Method \code{is_running()}}{
Checks whether the photon instance is running and ready. The difference
to \code{$is_ready()} is that \code{$is_running()} checks specifically
if the running photon instance is managed by a process from its own
\code{photon} object. In other words, \code{$is_running()} returns
\code{TRUE} if both \code{$proc$is_alive()} and \code{$is_ready()}
return \code{TRUE}. This method is useful if you want to ensure that
the \code{photon} object can control its photon server (mostly internal
use).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$is_running()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A logical of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-is_ready"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-is_ready}{}}}
\subsection{Method \code{is_ready()}}{
Checks whether the photon instance is ready to take requests. This
is the case if the photon server returns a HTTP 400 when sending a
queryless request. This method is useful if you want to check whether
you can send requests.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$is_ready()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A logical of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-get_url"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-get_url}{}}}
\subsection{Method \code{get_url()}}{
Constructs the URL that geocoding requests should be sent to.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$get_url()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A URL to send requests to.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-get_logs"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-get_logs}{}}}
\subsection{Method \code{get_logs()}}{
Retrieve the logs of previous photon runs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$get_logs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a dataframe containing the run ID (\code{rid}, the
highest number is the most recent run), a timestamp (\code{ts}), the
thread, the log type (INFO, WARN, or ERROR), the class trace and the
error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-photon_local-clone"></a>}}
\if{latex}{\out{\hypertarget{method-photon_local-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{photon_local$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
