% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_bin_2d_auto.R
\docType{data}
\name{stat_bin_2d_auto}
\alias{stat_bin_2d_auto}
\alias{stat_bin2d_auto}
\alias{StatBin2dAuto}
\title{Calculate two-dimensional bins using scale breaks}
\usage{
stat_bin_2d_auto(
  mapping = NULL,
  data = NULL,
  geom = "tile",
  position = "identity",
  ...,
  breaks = "all",
  bins = 30,
  binwidth = NULL,
  drop = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, bins, binwidth, drop, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d()}}.}

\item{breaks}{Controls the break positions for the bins.
Can be \code{NULL}, a numeric vector, or a function as per \code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}}.
Can additionally be a character specifying which breaks from the scale
should be used: \code{"minor"} for minor breaks, \code{"major"} for major breaks,
or \code{"all"} for both.
This can be a scalar or a list of length 2 to control the axes separately.}
}
\value{
ggplot2 stat layer.
}
\description{
This is mostly equivalent to \code{\link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d()}} except that the bin
edges can be copied from the scale breaks. For this effect to work properly,
you either need to use fixed scale breaks (e.g. using a vector instead of a
function), or use the \code{\link[=breaks_cached]{breaks_cached()}} helper.
}
\examples{
library(ggplot2)

ggplot(diamonds, aes(x, y)) +
  scale_x_continuous(limits = c(4, 10)) +
  scale_y_continuous(limits = c(4, 10)) +
  stat_bin_2d_auto()

# You can control the x and y binning separately:
ggplot(diamonds, aes(x, y)) +
  scale_x_continuous(limits = c(4, 10)) +
  scale_y_continuous(limits = c(4, 10)) +
  stat_bin_2d_auto(breaks = list("major", NULL), bins = list(NULL, 20))
}
\keyword{datasets}
