% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_bin_location.R
\docType{data}
\name{stat_bin_location}
\alias{stat_bin_location}
\alias{StatBinLocation}
\title{Annotate rows with 2D bin positions}
\usage{
stat_bin_location(
  mapping = NULL,
  data = NULL,
  geom = "rect",
  position = "identity",
  ...,
  overflow = FALSE,
  breaks = NULL,
  bins = 30,
  binwidth = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, bins, binwidth, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d()}}.}

\item{overflow}{If \code{TRUE}, map values that would normally be outside the
range to peripheral bins that span from the closest limit to the closest
infinity. You can control this for x and y separately by passing a list.}

\item{breaks}{Controls the break positions for the bins.
Can be \code{NULL}, a numeric vector, or a function as per \code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}}.
Can additionally be a character specifying which breaks from the scale
should be used: \code{"minor"} for minor breaks, \code{"major"} for major breaks,
or \code{"all"} for both.
This can be a scalar or a list of length 2 to control the axes separately.}
}
\value{
ggplot2 stat layer.
}
\description{
Unlike normal binning stat, this stat does not change the number of rows in
the data. Rather than summing weights, it merely adds \code{xmin}, \code{xmax}, \code{ymin},
and \code{ymax} values to the original data. This is useful for \code{\link[=geom_calendar]{geom_calendar()}},
which only has one tile per row and therefore would only have a single entry
contributing to each bin. \code{\link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d()}} would cause the other
fields to be discarded since it summarises the data.
}
\keyword{datasets}
