% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piece3d-rgl.R
\name{piece3d}
\alias{piece3d}
\title{Render board game pieces with rgl}
\usage{
piece3d(
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  x = 0,
  y = 0,
  z = NA,
  angle = 0,
  axis_x = 0,
  axis_y = 0,
  width = NA,
  height = NA,
  depth = NA,
  envir = getOption("piecepackr.envir"),
  ...,
  scale = 1,
  res = 72,
  alpha = 1,
  lit = FALSE,
  shininess = 50,
  textype = NA
)
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{z}{z-coordinate of the piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{axis_x}{First coordinate of the axis unit vector.}

\item{axis_y}{Second coordinate of the axis unit vector.}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{depth}{Depth (thickness) of piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{...}{Ignored.}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{res}{Resolution of the faces.}

\item{alpha}{Alpha channel for transparency.}

\item{lit}{logical, specifying if rgl lighting calculation should take place.}

\item{shininess}{Properties for rgl lighting calculation.}

\item{textype}{Use \code{"rgba"} when sure texture will have alpha transparency.
Use \code{"rgb"} when sure texture will not have alpha transparency
(in particular \code{rgl}'s WebGL export will likely work better).
If \code{NA} we will read the texture and figure out a reasonable value.}
}
\value{
A numeric vector of rgl object IDs.
}
\description{
\code{piece3d()} draws board games pieces using the rgl package.
}
\examples{
if (requireNamespace("rgl", quietly = TRUE) && all(capabilities(c("cairo", "png")))) {
  rgl::open3d()
  cfg <- game_systems("sans", border = FALSE)$piecepack
  piece3d("tile_back", suit = 3, rank = 3, cfg = cfg, x = 0, y = 0, z = 0)
  piece3d("coin_back", suit = 4, rank = 2, cfg = cfg, x = 0.5, y = 0.5, z = 0.25)
  piece3d("pawn_top", suit = 1, cfg = cfg, x = -0.5, y = 0.5, z = 0.6)
  piece3d("die_face", suit = 3, cfg = cfg, x = -0.5, y = -0.5, z = 0.375)
  piece3d("pyramid_top", suit = 2, rank = 3, cfg = cfg, x = 1.5, y = 0.0, z = 0.31875)
  invisible(NULL)
}
}
\seealso{
See \code{\link[rgl]{rgl-package}} for more information about the \code{rgl} package.
See \code{\link[rgl:material]{rgl::material3d()}} for more info about setting \code{rgl} material properties.
See \code{\link{geometry_utils}} for a discussion of the 3D rotation parameterization.
}
