% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dSep.R
\name{dSep}
\alias{dSep}
\title{Tests of directed separation}
\usage{
dSep(
  modelList,
  basis.set = NULL,
  direction = NULL,
  interactions = FALSE,
  conserve = FALSE,
  conditioning = FALSE,
  .progressBar = TRUE
)
}
\arguments{
\item{modelList}{A list of structural equations created using \code{psem}.}

\item{basis.set}{An optional list of independence claims.}

\item{direction}{A \code{vector} of claims defining the specific
directionality of independence claims; for use in special cases (see
Details).}

\item{interactions}{whether interactions should be included in independence claims. 
Default is FALSE}

\item{conserve}{Whether the most conservative P-value should be returned;
for use in special cases (see Details). Default is FALSE.}

\item{conditioning}{Whether the conditioning variables should be shown in
the summary table. Default is FALSE.}

\item{.progressBar}{An optional progress bar. Default is TRUE.}
}
\value{
Returns a \code{data.frame} of independence claims and their
significance values.
}
\description{
Evaluation of conditional independence claims to be used in determining the
goodness-of-fit for piecewise structural equation models.
}
\details{
In cases involving non-normally distributed responses in the independence
claims that are modeled using generalized linear models, the significance of
the independence claim is not reversible (e.g., the P-value of Y ~ X is not
the same as X ~ Y). This is due to the transformation of the response via
the link function. In extreme cases, this can bias the goodness-of-fit
tests. \code{summary.psem} will issue a warning when this case is present
and provide guidance for solutions.

One solution is to specify the directionality of the relationship using the
\code{direction} argument, e.g. \code{direction = c("X <- Y")}. Another is
to run both tests (Y ~ X, X ~ Y) and return the most conservative (i.e.,
lowest) P-value, which can be toggled using the \code{conserve = TRUE}
argument.
}
\references{
Shipley, Bill. "A new inferential test for path models based on
directed acyclic graphs." Structural Equation Modeling 7.2 (2000): 206-218.
}
\seealso{
\code{\link{basisSet}}
}
\author{
Jon Lefcheck <jslefche@gmail.com>, Jarrett Byrnes
}
