% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_transactions_municipality.R
\name{get_pix_transactions_by_region}
\alias{get_pix_transactions_by_region}
\title{Get PIX Transactions by Region}
\usage{
get_pix_transactions_by_region(database, verbose = TRUE)
}
\arguments{
\item{database}{Character string in "YYYYMM" format specifying which month's
data to retrieve. This parameter is \strong{required}.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with PIX transaction data aggregated by region.
}
\description{
A convenience wrapper that aggregates municipality data at the region level.
}
\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get region-level aggregates
regions <- get_pix_transactions_by_region(database = "202512")
}
}
