% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_block.R
\name{set_block}
\alias{set_block}
\title{Set values in rectangular areas of a plate}
\usage{
set_block(plate, block, what, value)
}
\arguments{
\item{plate}{A table representing a multiwell plate, with one column
named \dQuote{well} representing the well identifiers.}

\item{block}{Coordinates of a rectangular block (such as \dQuote{A01~B02}),
or a vector of coordinates.}

\item{what}{A column name in the table.}

\item{value}{The value to set.}
}
\value{
Returns the \sQuote{\code{plate}} table, where the values for
the wells indicated in the blocks have been updated.
}
\description{
Updates a table representing a multiwell plate, by setting a given value
for all wells in a block or a list of blocks defined by the well coordinates
of their upper-left and bottom-right corners.
}
\examples{
p <- data.frame(well = num_to_well(1:96))
head(p)

p <- set_block(p, c("A01~B02", "A05~D05"), "dNTP", 0.25)
p <- set_block(p,   "A03",                 "dNTP", 0.50)
head(p)

# Be careful with the column names
p <- set_block(p, "A01~H12", "Mg2+", 3.0)
head(p)

\dontrun{
# Chained updates with magrittr
p \%<>\%
  setBlock("A01~C04", "dNTP", 0.5) \%>\%
  setBlock("A01~C04", "Mg",   3.0)
}

}
\seealso{
\code{\link{num_to_well}}
}
\author{
Charles Plessy
}
