% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeltaB2vroles.R
\name{DeltaB2vroles}
\alias{DeltaB2vroles}
\alias{DeltaB2vroles_cat3logit}
\alias{DeltaB2vroles_ord3logit}
\title{Identification of roles of vertices in non-degenerate cases}
\usage{
DeltaB2vroles_cat3logit(DeltaB)

DeltaB2vroles_ord3logit(DeltaB)
}
\arguments{
\item{DeltaB}{either a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 2}}
or a vector of length 2, if the model is \emph{categorical}; otherwise
a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 1}} or a \code{numeric},
if the model is \emph{ordinal}.}
}
\value{
Named \code{list} of three components:

\item{vo}{coordinates of vertex where the field originates from.}
\item{vt}{coordinates of transition vertex.}
\item{vs}{coordinates of vertex where the field is directed to.}
}
\description{
\code{DeltaB2vroles_cat3logit} and \code{DeltaB2vroles_ord3logit} identify
(in a categorical and an ordinal model respectively)
the role of vertices of a field associated to a change in
covariate values \eqn{\Delta\in\textbf{R}^k}.
}
\keyword{internal}
