% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_roc.R
\name{export_interactive_roc}
\alias{export_interactive_roc}
\title{Generate svg code for an ROC curve object}
\usage{
export_interactive_roc(
  ggroc_p,
  add.cis = TRUE,
  hide.points = FALSE,
  prefix = "a",
  width = 6,
  height = 6,
  omit.js = FALSE,
  style = style_roc(theme = theme_grey()),
  ...
)
}
\arguments{
\item{ggroc_p}{A ggplot object with a GeomRoc layer and optionally a
GeomRocci layer as returned by \link{geom_roc} and/or \link{geom_rocci}. It can
be modified with annotations, themes, etc.}

\item{add.cis}{Logical, if true, removes the current confidence interval 
layer (if present) and replaces it with a denser layer of confidence 
regions}

\item{hide.points}{Logical, if true, hides points layer so that points with cutoff values are
only visible when hovering. Recommended for plots containing more than 3 curves.}

\item{prefix}{A string to assign to the objects within the svg. Enables 
unique identification by the javascript code}

\item{width, height}{Width and height in inches of plot}

\item{omit.js}{Logical. If true, omit inclusion of javascript source in 
output. Useful for documents with multiple interactive plots}

\item{style}{A call to the function \link{style_roc}}

\item{...}{Other arguments passed to \link{geom_rocci} when \code{add.cis = 
TRUE}}
}
\value{
A character object containing the html necessary to plot the ROC 
  curve in a web browser
}
\description{
Takes a ggplot object that contains a GeomRoc layer and returns a string that
contains html suitable for creating a standalone interactive ROC curve plot.
}
\details{
If you intend to include more than one of these objects in a single 
  page, use a different \code{prefix} string for each one. To use this 
  function in knitr, use the chunk options \code{fig.keep='none'} and 
  \code{results = 'asis'}, then \code{cat()} the resulting string to the 
  output. See the vignette for examples. Older browsers (< IE7) are not 
  supported.
}
