% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsmod-package.R
\docType{package}
\name{plsmod-package}
\alias{plsmod}
\alias{plsmod-package}
\title{parsnip methods for partial least squares (PLS)}
\description{
\pkg{plsmod} offers a function to fit ordinary, sparse, and discriminant
analysis PLS models.
}
\details{
The model function works with the tidymodels infrastructure so that the model
can be resampled, tuned, tided, etc.
}
\section{Examples}{
For regression, let’s use the Tecator data in the modeldata package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)
library(plsmod)
tidymodels_prefer()
theme_set(theme_bw())

data(meats, package = "modeldata")
}\if{html}{\out{</div>}}

Note that using \code{tidymodels_prefer()} will resulting getting
\code{parsnip::pls()} instead of \code{mixOmics::pls()} when simply running
\code{pls()}.

Although plsmod can fit multivariate models, we’ll concentration on a
univariate model that predicts the percentage of protein in the samples.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{meats <- meats \%>\% select(-water, -fat)
}\if{html}{\out{</div>}}

We define a sparse PLS model by setting the \code{predictor_prop} argument to
a value less than one. This allows the model fitting process to set
certain loadings to zero via regularization.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sparse_pls_spec <- 
  pls(num_comp = 10, predictor_prop = 1/3) \%>\% 
  set_engine("mixOmics") \%>\% 
  set_mode("regression")
}\if{html}{\out{</div>}}

The model is fit either with a formula or by passing the predictors and
outcomes separately:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{form_fit <- 
  sparse_pls_spec \%>\% 
  fit(protein ~ ., data = meats)
form_fit
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## parsnip model object
## 
## 
## Call:
##  mixOmics::spls(X = x, Y = y, ncomp = ncomp, keepX = keepX) 
## 
##  sPLS with a 'regression' mode with 10 sPLS components. 
##  You entered data X of dimensions: 215 100 
##  You entered data Y of dimensions: 215 1 
## 
##  Selection of [34] [34] [34] [34] [34] [34] [34] [34] [34] [34] variables on each of the sPLS components on the X data set. 
##  Selection of [1] [1] [1] [1] [1] [1] [1] [1] [1] [1] variables on each of the sPLS components on the Y data set. 
## 
##  Main numerical outputs: 
##  -------------------- 
##  loading vectors: see object$loadings 
##  variates: see object$variates 
##  variable names: see object$names 
## 
##  Functions to visualise samples: 
##  -------------------- 
##  plotIndiv, plotArrow 
## 
##  Functions to visualise variables: 
##  -------------------- 
##  plotVar, plotLoadings, network, cim
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# or 

sparse_pls_spec \%>\% 
  fit_xy(x = meats \%>\% select(-protein), y = meats$protein)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## parsnip model object
## 
## 
## Call:
##  mixOmics::spls(X = x, Y = y, ncomp = ncomp, keepX = keepX) 
## 
##  sPLS with a 'regression' mode with 10 sPLS components. 
##  You entered data X of dimensions: 215 100 
##  You entered data Y of dimensions: 215 1 
## 
##  Selection of [34] [34] [34] [34] [34] [34] [34] [34] [34] [34] variables on each of the sPLS components on the X data set. 
##  Selection of [1] [1] [1] [1] [1] [1] [1] [1] [1] [1] variables on each of the sPLS components on the Y data set. 
## 
##  Main numerical outputs: 
##  -------------------- 
##  loading vectors: see object$loadings 
##  variates: see object$variates 
##  variable names: see object$names 
## 
##  Functions to visualise samples: 
##  -------------------- 
##  plotIndiv, plotArrow 
## 
##  Functions to visualise variables: 
##  -------------------- 
##  plotVar, plotLoadings, network, cim
}\if{html}{\out{</div>}}

The \code{pls()} function can also be used with categorical outcomes.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://plsmod.tidymodels.org}
  \item \url{https://github.com/tidymodels/plsmod}
  \item Report bugs at \url{https://github.com/tidymodels/plsmod/issues}
}

}
\author{
\strong{Maintainer}: Max Kuhn \email{max@rstudio.com} (\href{https://orcid.org/0000-0003-2402-136X}{ORCID})

Other contributors:
\itemize{
  \item RStudio [copyright holder]
}

}
\keyword{internal}
