% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_pl}
\alias{theme_pl}
\title{a new extensible theme}
\usage{
theme_pl(
  base_size = 10,
  base_line_size = lpt(base_size/10),
  base_rect_size = lpt(1),
  size_scales = c(5, 6, 7),
  margin_factor = 0.25,
  plot_margin_factor = 0.5,
  legend_spacing_factor = 1.2,
  font_family = "",
  ...
)
}
\arguments{
\item{base_size}{base size of fonts and margins}

\item{base_line_size}{base linewidth}

\item{base_rect_size}{base linewidth of the rectangles}

\item{size_scales}{a vector of element size scales, namely:
\enumerate{
\item base size, used by legend text, axis text, caption
\item used by legend title, axis title, strip text (facet title), subtitle
\item used by title, tag
}}

\item{margin_factor}{factor to adjust the element margins according to
size_scales}

\item{plot_margin_factor}{factor to adjust the plot margins according to
\code{size_scales[3]}}

\item{legend_spacing_factor}{factor to adjust the space of legend items
according to \code{size_scales[2]}}

\item{font_family}{font family}

\item{...}{arguments from ggplot2::theme()}
}
\value{
theme object of ggplot
}
\description{
a new extensible theme
}
\examples{
theme_pl()
}
