% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot.pmcalibration}
\alias{plot.pmcalibration}
\title{Plot a calibration curve}
\usage{
\method{plot}{pmcalibration}(
  x,
  conf_level = 0.95,
  riskdist = TRUE,
  linecol = "black",
  fillcol = "grey",
  ideallty = 2,
  idealcol = "red",
  ...
)
}
\arguments{
\item{x}{a \code{pmcalibration} calibration curve}

\item{conf_level}{width of the confidence interval (0.95 gives 95\% CI). Ignored if call to \code{pmcalibration} didn't request confidence intervals}

\item{riskdist}{add risk distribution plot under calibration curve (TRUE) or not (FALSE)}

\item{linecol}{color of the calibration curve line}

\item{fillcol}{color of the confidence interval}

\item{ideallty}{line type of the ideal unit slope line}

\item{idealcol}{color of the ideal unit slope line}

\item{...}{other args for \code{plot()} (currently only \code{lim}s and \code{lab}s can be specified)}
}
\value{
No return value, called for side effects
}
\description{
Plot a \code{pmcalibration} object. For binary outcomes, also plot the distribution of predicted risks by outcome.
Alternatively you can use \code{get_curve()} to get the data required to plot the calibration curve.
}
\examples{
library(pmcalibration)
# simulate some data with a binary outcome
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)
head(dat)
# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

# fit calibration curve
cal <- pmcalibration(y = dat$y, p = p, smooth = "gam", k = 20, ci = "pw", plot = FALSE)

plot(cal, xlab = "Predicted Risk of Outcome") # customize plot
}
