% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/politenessProjection.R
\name{politenessProjection}
\alias{politenessProjection}
\title{Politeness projection}
\usage{
politenessProjection(df_polite_train, covar = NULL, ...)
}
\arguments{
\item{df_polite_train}{a data.frame with politeness features as outputed by \code{\link{politeness}} used to train model.}

\item{covar}{a vector of politeness labels, or other covariate.}

\item{...}{additional parameters to be passed. See \code{\link{trainModel}}.}
}
\value{
list of model objects.
}
\description{
Deprecated. Function is now called \code{\link{trainModel}}.
}
\details{
See \code{\link{trainModel}} for details.
}
\examples{

data("phone_offers")
data("bowl_offers")

polite.data<-politeness(phone_offers$message, parser="none",drop_blank=FALSE)

polite.holdout<-politeness(bowl_offers$message, parser="none",drop_blank=FALSE)

project<-politenessProjection(polite.data,
                              phone_offers$condition,
                              polite.holdout)

# Difference in average politeness across conditions in the new sample.

mean(project$test_proj[bowl_offers$condition==1])
mean(project$test_proj[bowl_offers$condition==0])

}
