% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdemo-deprecated.R
\name{popdemo-deprecated}
\alias{popdemo-deprecated}
\alias{Cohen.cumulative}
\alias{Cohen.cumulative-deprecated}
\alias{convergence.time}
\alias{convergence.time-deprecated}
\alias{inertia.tfa}
\alias{inertia.tfa-deprecated}
\alias{inertia.tfamatrix}
\alias{inertia.tfamatrix-deprecated}
\alias{inertia.tfsens}
\alias{inertia.tfsens-deprecated}
\alias{inertia.tfsensmatrix}
\alias{inertia.tfsensmatrix-deprecated}
\alias{is.matrix_ergodic}
\alias{is.matrix_ergodic-deprecated}
\alias{is.matrix_irreducible}
\alias{is.matrix_irreducible-deprecated}
\alias{is.matrix_primitive}
\alias{is.matrix_primitive-deprecated}
\alias{Keyfitz.delta}
\alias{Keyfitz-delta-deprecated}
\alias{projection.distance}
\alias{projection.distance-deprecated}
\alias{tfa}
\alias{tfa-deprecated}
\alias{tfamatrix}
\alias{tfamatrix-deprecated}
\alias{tfsens}
\alias{tfsens-deprecated}
\alias{tfsensmatrix}
\alias{tfsensmatrix-deprecated}
\alias{minCS}
\alias{minCS-deprecated}
\alias{tf}
\alias{tf-deprecated}
\alias{reactivity}
\alias{reactivity-deprecated}
\alias{firststepatt}
\alias{firststepatt-deprecated}
\title{Deprecated functions in the popdemo package}
\usage{
Cohen.cumulative(...)
convergence.time(...)
inertia.tfa(...)
inertia.tfamatrix(...)
inertia.tfsens(...)
inertia.tfsensmatrix(...)
is.matrix_ergodic(...)
is.matrix_irreducible(...)
is.matrix_primitive(...)
Keyfitz.delta(...)
projection.distance(...)
tfa(...)
tfamatrix(...)
tfsens(...)
tfsensmatrix(...)
minCS(...)
reactivity(...)
firststepatt(...)
}
\arguments{
\item{...}{Parameters to be passed to the new function versions}
}
\description{
Deprecated functions in the popdemo package
}
\details{
Many functions have become deprecated as of popdemo_1.0-0 (meaning they will stop
working at some point in the future). In most cases, this is because 
functions needed to be re-named. For now the older function names will 
work but issue a warning, but you should use the new function names wherever possible.
Please update your code, and I'm sorry for the inconvenience!

\describe{
\item{Avoiding S3 troubles}{
Most deprecated functions needed to be renamed because they included a period 
in the function name: the new function names don't use periods, which is a 
better approach for playing nicely with the S3 object-oriented system (see Hadley 
Wickham's \href{http://adv-r.had.co.nz/OO-essentials.html}{OO field guide} for more
info). These are:
\tabular{rl}{
  \code{Cohen.cumulative} \tab now called \code{CohenD}\cr
  \code{convergence.time} \tab now called \code{convt}\cr
  \code{inertia.tfa} \tab now called \code{tfa_inertia}\cr
  \code{inertia.tfamatrix} \tab now called \code{tfam_inertia}\cr
  \code{inertia.tfsens} \tab now called \code{tfs_inertia}\cr
  \code{inertia.tfsensmatrix} \tab now called \code{tfsm_inertia}\cr
  \code{is.matrix_ergodic} \tab now called \code{isErgodic}\cr
  \code{is.matrix_irreducible} \tab now called \code{isIrreducible}\cr
  \code{is.matrix_primitive} \tab now called \code{isPrimitive}\cr
  \code{Keyfitz.delta} \tab now called \code{KeyfitzD}\cr
  \code{projection.distance} \tab now called \code{projectionD}\cr
}
}
\item{Consistency}{
Some other functions have been renamed to keep consistency with new functions, 
and also to further avoid problems with S3 methods by making sure classes and 
functions don't have the same names:
\tabular{rl}{
  \code{tfa} \tab now called \code{tfa_lambda}\cr
  \code{tfamatrix} \tab now called \code{tfam_lambda}\cr
  \code{tfsens} \tab now called \code{tfs_lambda}\cr
  \code{tfsensmatrix} \tab now called \code{tfsm_lambda}\cr
}
}
\item{Hidden functions}{
Some functions have been made internal (they're "hidden" but you can still 
use them):
\tabular{rl}{
  \code{minCS} \tab now called \code{.minCS}\cr
  \code{tf} \tab now called \code{.tf}\cr
}
}
\item{Merged functions}{
Two functions are deprecated because they have been merged into one:
\tabular{rl}{
  \code{reactivity,firststepatt} \tab now handled by \code{\link{reac}}.\cr
}
Before, \code{reactivity} handled first-timestep amplification and 
\code{firststepatt} handled first-timestep attenuation. This is silly, because
a projection EITHER amplifies OR attenuates in the first timestep. Desptite 
the semantics, \code{\link{reac}} now deals with both amplification and attenuation
in the first timestep, everything that was calculable in the previous two
functions is also calculable in the one new function.
}
}
}
