% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfr_to_asfr.R
\name{tfr_to_asfr_scale}
\alias{tfr_to_asfr_scale}
\title{Derive Age-Specific Fertility Rates that
Match Total Fertility Rates by Scaling}
\usage{
tfr_to_asfr_scale(target, standard, suffix = NULL)
}
\arguments{
\item{target}{A data frame containing a variable called
\code{"tfr"}, and possibly others. See Details.}

\item{standard}{A data frame containing variables
called \code{age} and \code{asfr}, and possibly others.
See details.}

\item{suffix}{Optional suffix added to
\code{asfr} column in results.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
Turn total fertility rates (TFRs) into sets
of age-specific fertility rates, by scaling
a set of standard rates upwards or downwards.
}
\section{Method}{


The age-specific rates are derived by finding
a value \eqn{\alpha} such that

\deqn{f_x = \alpha f_x^{\mathrm{std}}}

and

\deqn{sum_x f_x = F}

where
\itemize{
\item \eqn{f_x} is the age-specific fertility rate;
\item \eqn{f_x^{\mathrm{std}}} is the standard schedule of rates;
\item \eqn{\alpha} is a multiplier shared by all age groups; and
\item \eqn{F} is the target total fertility rate.
}
}

\section{\code{target} argument}{


\code{target} is a data frame specifying
total fertility rates for each population being modelled,
Values in \code{target} are not age-specific.

Variables in \code{target}:
\itemize{
\item A variable called \code{"tfr"}. Can be an ordinary
numeric variable, or an \link[rvec:rvec]{rvec()}.
\item Optionally, 'by' variables distinguishing
populations, such as \code{"region"} or \code{"time"}.
}
}

\section{\code{standard} argument}{


\code{standard} is a data frame specifying
standard fertility scedules to be used
with each life expectancy
in \code{target}. Values in \code{standard} are age-specific.

Variables in \code{standard}:
\itemize{
\item A variable called \code{"age"}, with labels that
can be parsed by \code{\link[=reformat_age]{reformat_age()}}.
\item A variable called \code{"value"}, containing
non-negative values.  Cannot be an rvec.
\item Additional variables used to match rows in \code{standard}
to rows in \code{target}.
}

Internally, \code{standard} is merged with
\code{target} using a left join from \code{target},
on any variables that \code{target}
and \code{standard} have in common.
}

\examples{
## create age-specific fertility rates
## based on the [Booth standard][booth_standard]
library(dplyr, warn.conflicts = FALSE)
target <- data.frame(region = c("A", "B"), 
                     tfr = c(5.5, 4.7))
asfr <- tfr_to_asfr_scale(target = target,
                          standard = booth_standard)
asfr

## check consistency with original TFRs
asfr |>
  tfr(asfr = asfr, by = region)
}
\seealso{
\itemize{
\item \code{\link[=ex_to_lifetab_brass]{ex_to_lifetab_brass()}} Life table equivalent
of \code{tfr_to_asfr_scale()}.
\item \link{booth_standard} The 'Booth standard' fertility schedule
\item \link{tfr} Calculate total fertility rate from age-specific
fertility rates
}
}
