% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo.poth}
\alias{loo.poth}
\alias{loo}
\alias{print.loo.poth}
\title{Leave-one-out method for precision of treatment hierarchy (POTH) metric}
\usage{
\method{loo}{poth}(x, ...)

loo(x, ...)

\method{print}{loo.poth}(x, digits = 3, legend = TRUE, ...)
}
\arguments{
\item{x}{An R object of class \code{poth}.}

\item{\dots}{Additional arguments.}

\item{digits}{Minimal number of significant digits, see
\code{\link{print.default}}.}

\item{legend}{A logical indicating whether a legend should be
printed.}
}
\value{
A data frame with additional class \code{loo.poth} and the following
  variables:
\item{trt}{Treatment names.}
\item{rank}{Treatment rank (global).}
\item{score}{Ranking metric (global).}
\item{poth_loo}{Leave-one-out POTH.}
\item{resid}{Residuals (global POTH minus leave-one-out POTH.}
\item{ratio}{Ratio of residual devided by absolute sum of residuals.}
}
\description{
Leave-one-out method for precision of treatment hierarchy (POTH) metric
}
\examples{
library("netmeta")
data(smokingcessation)
p1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")
net1 <- netmeta(p1, random = FALSE)

# Leave-one-out method
loo1 <- loo(poth(net1))
loo1

}
\keyword{print}
