% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpexpow.R, R/ppexpow.R, R/qpexpow.R,
%   R/rpexpow.R
\name{PowerExponentialPower}
\alias{PowerExponentialPower}
\alias{dpexpow}
\alias{PowerExponentialPower}
\alias{ppexpow}
\alias{PowerExponentialPower}
\alias{qpexpow}
\alias{PowerExponentialPower}
\alias{rpexpow}
\title{The Power Exponential Power Distribution}
\usage{
dpexpow(x, lambda = 1, mu = 0, sigma = 1, k = 0, log = FALSE)

ppexpow(q, lambda = 1, mu = 0, sigma = 1, k = 0, lower.tail = TRUE,
  log.p = FALSE)

qpexpow(p, lambda = 1, mu = 0, sigma = 1, k = 0, lower.tail = TRUE,
  log.p = FALSE)

rpexpow(n, lambda = 1, mu = 0, sigma = 1, k = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters.}

\item{k, lambda}{shape parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power exponential power distribution with parameters mu, sigma, lambda and k.
}
\details{
The power exponential power distribution has density

\eqn{f\left(x\right)=\frac{\lambda}{\sigma}\left[\frac{e^{-\left(\frac{x-\mu}{\sigma}\right)}}{\left(1+e^{-\left(\frac{x-\mu}{\sigma}\right)}\right)^{2}}\right]\left[\frac{e^{\left(\frac{x-\mu}{\sigma}\right)}}{1+e^{\left(\frac{x-\mu}{\sigma}\right)}}\right]^{\lambda-1}}{f(x)=[\lambda/\sigma][exp(-(x-\mu)/\sigma)/(1+exp(-(x-\mu)/\sigma)))^2][exp((x-\mu)/\sigma)/(1+exp((x-\mu)/\sigma)]^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} and k the shape parameters.
}
\examples{
dpexpow(1, 1, 3, 4, 1)
ppexpow(1, 1, 3, 4, 1)
qpexpow(0.2, 1, 3, 4, 1)
rpexpow(5, 2, 3, 4, 1)
}
\references{
Lemonte A. and Bazán J.L.
}
