% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindParameters.R
\name{revert_power_transform}
\alias{revert_power_transform}
\title{Revert transformation}
\usage{
revert_power_transform(y, transformer)
}
\arguments{
\item{y}{A vector with numeric values that was previously transformed to
normality.}

\item{transformer}{A transformer object created using
\code{find_transformation_parameters} that was used to transform the values to
normality previously. Cannot be \code{NULL}.}
}
\value{
A vector of values.
}
\description{
\code{revert_power_transform} reverts the transformation of numeric values to
normality.
}
\examples{
x0 <- exp(stats::rnorm(1000))

transformer <- find_transformation_parameters(
  x = x0,
  method = "box_cox")

y <- power_transform(
  x = x0,
  transformer = transformer)

x1 <- revert_power_transform(
  y = y,
  transformer = transformer)
}
