% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_data.R
\docType{data}
\name{ppiIND2016_r68}
\alias{ppiIND2016_r68}
\title{Poverty Probability Index (PPI) lookup table for India using r68 poverty
definitions}
\format{
A data frame with 16 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{rangarajan100}}{National rangarajan (100\%)}
\item{\code{rangarajan150}}{National rangarajan (150\%)}
\item{\code{rangarajan200}}{National rangarajan (200\%)}
\item{\code{half100}}{Poorest half below 100\% national}
\item{\code{rbiUrban}}{RBI urban}
\item{\code{rbiRural}}{RBI rural}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp310}}{Below $3.10 per day purchasing power parity (2011)}
\item{\code{ppp380}}{Below $3.80 per day purchasing power parity (2011)}
\item{\code{ppp400}}{Below $4.00 per day purchasing power parity (2011)}
\item{\code{percentile20}}{Below 20th percentile poverty line}
\item{\code{percentile40}}{Below 40th percentile poverty line}
\item{\code{percentile50}}{Below 50th percentile poverty line}
\item{\code{percentile60}}{Below 60th percentile poverty line}
\item{\code{percentile80}}{Below 80th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiIND2016_r68
}
\description{
Poverty Probability Index (PPI) lookup table for India using r68 poverty
definitions
}
\examples{
  # Access India PPI table
  ppiIND2016_r68

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiIND2016_r68[ppiIND2016_r68$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiIND2016_r68, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # rangarajan poverty definition
  ppiScore <- 50
  ppiIND2016_r68[ppiIND2016_r68$score == ppiScore, "rangarajan100"]

}
\keyword{datasets}
