\name{pplot}
\alias{pplot}
\alias{pplot-package}
\docType{package}
\title{
Generating p-plots
}
\description{
Generates chronological and ordered p-plots for data vectors or vectors of p-values. The p-plot visualizes the evolution of the p-value of a significance test across the sampled data. It allows for assessing the consistency of the observed effects, for detecting the presence of potential moderator variables, and for estimating the influence of outlier values on the observed results. For non-significant findings, it can diagnose patterns indicative of underpowered study designs. The p-plot can thus either back the binary accept-vs-reject decision of common null-hypothesis significance tests, or it can qualify this decision and stimulate additional empirical work to arrive at more robust and replicable statistical inferences.
}
\details{
\tabular{ll}{
Package: \tab pplot\cr
Type: \tab Package\cr
Version: \tab 0.9\cr
Date: \tab 2025-04-04\cr
License: \tab GPL-3\cr
}
This package contains the following functions:
%\itemize{
\describe{
  \item{\code{\link[pplot:pplot.pvals]{pplot.pvals}}: }{Generates p-plot from a series of p-values.}
  \item{\code{\link[pplot:pplot.t.test]{pplot.t.test}}: }{Generates chronological or ordered p-plot from a series of data points.}
}
Version history:
%\itemize{
\describe{
  \item{v0.9  | 2025-04-03 | }{Package release.}
}
}
\author{
Roland Pfister <mail(at)roland-pfister.net>, Christian Frings; 
}
%\references{
%Pfister, R., & Janczyk, M. (2016). pplot: An R package for analyzing and reporting factorial experiments. \emph{The Quantitative Methods for Psychology}, \emph{12}(2), 147-151. doi: 10.20982/tqmp.12.2.p147
%}
\keyword{ package }
% \seealso{
%% ~~ Optional links to other man pages, e.g. ~~
%% ~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
% }
% \examples{
%% ~~ simple examples of the most important functions ~~
% }
