% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcovPC.R
\name{vcovPC.prais}
\alias{vcovPC.prais}
\title{Extract Panel-Corrected Variance Covariance Matrix}
\usage{
\method{vcovPC}{prais}(x, pairwise = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{"prais"}, usually, the result of a call to \code{\link{prais_winsten}}.}

\item{pairwise}{logical. If \code{FALSE} (default), only those residuals from periods that are common to
all panels are used to computed the covariances. If \code{TRUE} all observations that can be matched by
period between two panels are used.}

\item{...}{not used.}
}
\value{
An object of class "matrix".
}
\description{
Panel-corrected covariance matrix estimators for models of class \code{"prais"}.
}
\details{
\code{vcovPC} is a function for estimating a panel-corrected covariance matrix of parameters for
the Prais-Winsten estimator.
}
\references{
Beck, N. L. and Katz, J. N. (1995): What to do (and not to do) with time-series cross-section data. American Political Science Review 89, 634-647.
}
\seealso{
\code{\link[pcse]{vcovPC}}
}
