% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsmoothTP.R
\name{unsmoothTP}
\alias{unsmoothTP}
\title{This function implements unsmoothed estimates of from the Aalen-Johansen 
estimator (AJ) and landmark Aalen-Johansen method of Putter & Spitoni (2016) 
for non-parametric estimation of transition probabilities in non-Markov
multi-state models.}
\usage{
unsmoothTP(data, s, from, to, method = "LM", trans = trans)
}
\arguments{
\item{data}{A data frame in the long format containing the subject id; 
from corresponding to the starting state; the receiving state, to; the 
transition number, trans; the starting time of the transition given by 
Tstart; the stopping time of the transition, Tstop, and status for the status
variable, with 1 indicating an event (transition), 0 a censoring.}

\item{s}{The first time for obtaining estimates for the transition.}

\item{from}{The starting state of the transition probabilities.}

\item{to}{The last receiving state considered for the estimation of the 
transition probabilities.}

\item{method}{The method used to compute the transition probabilities.
Possible options are \code{"AJ"} and \code{"LM"}.}

\item{trans}{The transition matrix for multi-state model.}
}
\value{
Nonparametric estimates of transition probabilities in general 
multi-state models using the AJ and the LMAJ estimators.
}
\description{
This function is used to obtain nonparametric unsmoothed 
estimates of the transition probabilities. The methods used to compute the 
transition probabilities are ”AJ” and ”LM” which can be also applied for any
type of multistate model, including models that allow for reversible 
transitions, and potencially non-Markovian seetings.
}
\examples{
data("ebmt4")
db_wide <- ebmt4
positions<-list(c(2, 3, 5, 6), c(4, 5, 6), c(4, 5, 6), c(5, 6), c(6), c())
states.names = c("Tx", "Rec", "AE", "Rec+AE", "Rel", "Death")
trans<-transTP(positions, states.names)
times.names = c(NA, "rec", "ae","recae", "rel", "srv")
status.names=c(NA, "rec.s", "ae.s", "recae.s", "rel.s", "srv.s")
data.long<-prepTP(data=db_wide, trans, times.names, status.names)

res1<-unsmoothTP(data.long, s = 100, from = 1, to = 1, method = 'AJ', 
trans=trans)
head(res1)
res2<-unsmoothTP(data.long, s = 100, from = 1, to = 1, method = 'LM', 
trans=trans)
head(res2)
plot(res1, type='s', xlim=c(0,3000), ylim=c(0.6,1), ylab=c('p11(100,t)'))
lines(res2, type='s', col=2)
legend("topright", legend = c("AJ","LM"), lwd = 0.3, col = c(1,2), cex=0.7,
lty=c(1, 1))

res3<-unsmoothTP(data.long, s = 1000, from = 2, to = 6, method = 'AJ', 
trans=trans)
res4<-unsmoothTP(data.long, s = 1000, from = 2, to = 6, method = 'LM', 
trans=trans)

plot(res3, type='s', xlim=c(1000,3000), ylim=c(0,0.12), ylab=c('p26(100,t)'))
lines(res4, type='s', col=2)
legend("topright", legend = c("AJ","LM"), lwd = 0.3, col = c(1,2), cex=0.7,
lty=c(1, 1))
}
