% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast-models.R
\name{prevedere_raw_model}
\alias{prevedere_raw_model}
\title{Raw model}
\usage{
prevedere_raw_model(key, model_id, exclude_indicators = TRUE,
  as_of_date = NULL, raw = FALSE)
}
\arguments{
\item{key}{A Prevedere API key.}

\item{model_id}{UUID for the forecast model.}

\item{exclude_indicators}{Whether to return only indicators used in model (TRUE), or all associated indicators.}

\item{as_of_date}{Get the model only using data up to the specified date (YYYY-MM-DD). Used for backtesting.}

\item{raw}{Logical value indicating if data should be returned in its raw form
(typically nested lists) or formatted as appropriate, usually a dataframe.}
}
\value{
A list of model components and metadata, including indicators,
coefficients, and the model start date.
}
\description{
Returns all information about a forecast model.
}
\examples{
\dontrun{
k <- "1235467abcdefg"

prevedere_raw_model(key = k, model_id = "1b1878399833c7f38b094e54dd43d374")

## Backtest
prevedere_raw_model(key = k,
                    model_id = "1b1878399833c7f38b094e54dd43d374",
                    as_of_data = "2019-05-01")
}
}
\seealso{
Other forecast model functions: \code{\link{prevedere_forecast}}
}
\concept{forecast model functions}
