% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{union.default}
\alias{union.default}
\title{Union of Subsets
Calculates the union of subsets of a probability space.}
\usage{
\method{union}{default}(x, y, ...)
}
\arguments{
\item{x}{vectors, data frames, or \code{ps} objects containing a sequence of items (conceptually)}

\item{y}{vectors, data frames, or \code{ps} objects containing a sequence of items (conceptually)}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
A data frame or subset of a probability space of the same type as its arguments.
}
\description{
Union of Subsets
Calculates the union of subsets of a probability space.
}
\details{
This function operates row-wise on dataframes, and element-wise among the outcomes of \code{ps} objects. The elements of \code{union(x,y)} are those elements in \code{x} or \code{y}, or both. The definition is taken to match the version in the \code{base} package.
}
\examples{
S <- cards()
A <- subset(S, suit == "Heart")
B <- subset(S, rank == "A" )
union(A, B)
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}, based on a suggestion made by Brian Ripley in \code{R}-devel, 12/11/07.
}
