% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{promise_reduce}
\alias{promise_reduce}
\title{Promise-aware version of Reduce}
\usage{
promise_reduce(.x, .f, ..., .init)
}
\arguments{
\item{.x}{A vector or list to reduce. (Not a promise.)}

\item{.f}{A function that takes two parameters. The first parameter will be
the "result" (initially \code{.init}, and then set to the result of the most
recent call to \code{func}), and the second parameter will be an element of \code{.x}.}

\item{...}{Other arguments to pass to \code{.f}}

\item{.init}{The initial result value of the fold, passed into \code{.f} when it
is first executed.}
}
\value{
A promise that will resolve to the result of calling \code{.f} on the last
element (or \code{.init} if \code{.x} had no elements). If any invocation of \code{.f}
results in an error or a rejected promise, then the overall
\code{promise_reduce} promise will immediately reject with that error.
}
\description{
Similar to \code{\link[purrr:reduce]{purrr::reduce}} (left fold), but the function \code{.f} is permitted
to return a promise. \code{promise_reduce} will wait for any returned promise to
resolve before invoking \code{.f} with the next element; in other words, execution
is serial. \code{.f} can return a promise as output but should never encounter a
promise as input (unless \code{.x} itself is a list of promises to begin with, in
which case the second parameter would be a promise).
}
\examples{
# Returns a promise for the sum of e1 + e2, with a 0.5 sec delay
slowly_add <- function(e1, e2) {
  promise(\(resolve, reject) {
    later::later(\() resolve(e1 + e2), delay = 0.5)
  })
}

# Prints 55 after a little over 5 seconds
promise_reduce(1:10, slowly_add, .init = 0) |>
  then(print)

}
