% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trigrams.R
\name{hmm_trigrams}
\alias{hmm_trigrams}
\title{hmm_trigrams}
\usage{
hmm_trigrams(hmm)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}
}
\value{
A vector of length 8000
}
\description{
This feature is calculated with a 20 x 20 x 20 block \eqn{B}, in which \eqn{B[i, j, k] = \sum_{a = 1}^{L-2} H_{a, i}H_{a+1, j}H_{a+2, k}}.
\eqn{H} corresponds to the original HMM matrix, and \eqn{L} is the number of rows in \eqn{H}. Matrix \eqn{B} is then flattened to
a feature vector of length 8000, and returned.
}
\examples{
h<- hmm_trigrams(system.file("extdata", "1DLHA2-7", package="protHMM"))
}
\references{
Lyons, J., Dehzangi, A., Heffernan, R., Yang, Y., Zhou, Y., Sharma, A., & Paliwal, K. K. (2015).
Advancing the Accuracy of Protein Fold Recognition by Utilizing Profiles From Hidden Markov Models.
IEEE Transactions on Nanobioscience, 14(7), 761–772.
}
