% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par-02-parGOSim.R
\name{parGOSim}
\alias{parGOSim}
\title{Protein Similarity Calculation based on Gene Ontology
(GO) Similarity}
\usage{
parGOSim(
  golist,
  type = c("go", "gene"),
  ont = c("MF", "BP", "CC"),
  organism = "human",
  measure = "Resnik",
  combine = "BMA"
)
}
\arguments{
\item{golist}{A list, each component contains
a character vector of GO terms or one Entrez Gene ID.}

\item{type}{Input type for \code{golist}, \code{"go"} for GO Terms,
\code{"gene"} for gene ID.}

\item{ont}{Default is \code{"MF"}, can be one of \code{"MF"},
\code{"BP"}, or \code{"CC"} subontologies.}

\item{organism}{Organism name. Default is \code{"human"}, can be one of
\code{"anopheles"}, \code{"arabidopsis"}, \code{"bovine"}, \code{"canine"},
\code{"chicken"}, \code{"chimp"}, \code{"coelicolor"}, \code{"ecolik12"},
\code{"ecsakai"}, \code{"fly"}, \code{"human"}, \code{"malaria"},
\code{"mouse"}, \code{"pig"}, \code{"rat"}, \code{"rhesus"},
\code{"worm"}, \code{"xenopus"}, \code{"yeast"} or \code{"zebrafish"}.
Before specifying the organism, please install the corresponding genome wide
\href{https://bioconductor.org/packages/release/BiocViews.html#___OrgDb}{annotation data package}
for the selected organism.}

\item{measure}{Default is \code{"Resnik"}, can be one of
\code{"Resnik"}, \code{"Lin"}, \code{"Rel"}, \code{"Jiang"}
or \code{"Wang"}.}

\item{combine}{Default is \code{"BMA"}, can be one of \code{"max"},
\code{"average"}, \code{"rcmax"} or \code{"BMA"}
for combining semantic similarity scores of multiple GO terms
associated with proteins.}
}
\value{
A \code{n} x \code{n} similarity matrix.
}
\description{
This function calculates protein similarity based on
Gene Ontology (GO) similarity.
}
\examples{
\dontrun{

# Be careful when testing this since it involves GO similarity computation
# and might produce unpredictable results in some environments

library("GOSemSim")
library("org.Hs.eg.db")

# By GO Terms
# AP4B1
go1 <- c(
  "GO:0005215", "GO:0005488", "GO:0005515",
  "GO:0005625", "GO:0005802", "GO:0005905"
)
# BCAS2
go2 <- c(
  "GO:0005515", "GO:0005634", "GO:0005681",
  "GO:0008380", "GO:0031202"
)
# PDE4DIP
go3 <- c(
  "GO:0003735", "GO:0005622", "GO:0005840",
  "GO:0006412"
)
golist <- list(go1, go2, go3)
parGOSim(golist, type = "go", ont = "CC", measure = "Wang")

# By Entrez gene id
genelist <- list(c("150", "151", "152", "1814", "1815", "1816"))
parGOSim(genelist, type = "gene", ont = "BP", measure = "Wang")
}
}
\seealso{
See \code{\link{twoGOSim}} for calculating the
GO semantic similarity between two groups of GO terms or two Entrez gene IDs.
See \code{\link{parSeqSim}} for paralleled protein similarity
calculation based on Smith-Waterman local alignment.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
