% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spreadsheet.R
\name{read_spreadsheet}
\alias{read_spreadsheet}
\title{Convenience function to read spreadsheet-like files}
\usage{
read_spreadsheet(
  x,
  sheet = NULL,
  columnDictionary = NULL,
  localBackup = NULL,
  exportGoogleSheet = TRUE,
  flattenSingleDf = FALSE,
  xlsxPkg = c("rw_xl", "openxlsx", "XLConnect"),
  failQuietly = FALSE,
  silent = psyverse::opts$get("silent")
)
}
\arguments{
\item{x}{The URL or path to a file.}

\item{sheet}{Optionally, the name(s) of the worksheet(s) to select.}

\item{columnDictionary}{Optionally, a dictionary with column names to
check for presence. A named list of vectors.}

\item{localBackup}{If not \code{NULL}, a valid filename to write a local
backup to.}

\item{exportGoogleSheet}{If \code{x} is a URL to a Google Sheet, instead of using
the \code{googlesheets4} package to download the data, by passing
\code{exportGoogleSheet=TRUE}, an export link will be produced and the data
will be downloaded as Excel spreadsheet.}

\item{flattenSingleDf}{Whether to return the result as a data frame if
only one data frame is returned as a result.}

\item{xlsxPkg}{Which package to use to work with Excel spreadsheets.}

\item{failQuietly}{Whether to give an error when \code{x} is not a valid URL
or existing file, or just return \code{NULL} invisibly.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
A list of dataframes, or, if only one data frame was loaded and
\code{flattenSingleDf} is \code{TRUE}, a data frame.
}
\description{
Currently reads spreadsheets from Google Sheets or from \code{xlsx}, \code{csv},
or \code{sav} files. Normally, you don't use this, but instead you
use \code{\link[=dct_from_spreadsheet]{dct_from_spreadsheet()}}.
}
\examples{
\donttest{
### Note that this example requires an internet connection!
read_spreadsheet(
  paste0(
    "https://docs.google.com/",
    "spreadsheets/d/",
    "1bHDzpCu4CwEa5_3_q_9vH2691XPhCS3e4Aj_HLhw_U8"
  )
);
}
}
