% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptglm.R
\name{ptglm}
\alias{ptglm}
\title{Poisson-Tweedie generalized linear model}
\usage{
ptglm(formula, offset = NULL, data, maxit = c(500, 1e+05), trace = T,
  theta.start = NULL)
}
\arguments{
\item{formula}{A formula for the fixed effects part of the model. It should be in the form \code{y ~ x1 + x2}}

\item{offset}{An offset to be added to the linear predictor. Default is \code{NULL}.}

\item{data}{A data frame containing the variables declared in \code{formula}.}

\item{maxit}{Vector containing the maximum number of iterations used in optim by
the BFGS method and, if this fails, by the Nelder-Mead method}

\item{trace}{Logical value. If \code{TRUE}, additional information is printed during the optimization. Default is \code{TRUE}.}

\item{theta.start}{Numeric vector comprising initial parameter values for the
vector of regression coefficients, the dispersion parameter and the power parameter 
(to be specified exactlyin this order!).}
}
\value{
A list containing the following elements: function's call (\code{call}); 
maximum likelihood estimate (\code{mle});  value of the
loglikelihood at the mle (\code{logl}); \code{convergence} value (if 0, the optimization converged);
the observed Fisher information (\code{fisher.info}) and the starting values
used in the optimization (\code{theta.init})
}
\description{
Estimates a Poisson-Tweedie generalized linear model.
}
\examples{
data(df1, package = 'ptmixed')

# estimate the model
fit1 = ptglm(formula = y ~ group*time, data = df1)

# view model summary:
summary(fit1)
}
\references{
Signorelli, M., Spitali, P., Tsonaka, R. (2021). Poisson-Tweedie 
mixed-effects model: a flexible approach for the analysis of longitudinal RNA-seq
data. Statistical Modelling, 21 (6), 520-545. URL: https://doi.org/10.1177/1471082X20936017
}
\seealso{
\code{\link{ptmixed}} for the Poisson-Tweedie GLMM
}
\author{
Mirko Signorelli
}
