% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{view.paths}
\alias{view.paths}
\title{view.paths}
\usage{
view.paths(
  from,
  to,
  sem.functions,
  data,
  minimum.x = NULL,
  maximum.x = NULL,
  scale = "response",
  return.values = FALSE,
  dag
)
}
\arguments{
\item{from}{The name (character) of the variable at the beginning of the path}

\item{to}{The name (character) of the variable at the end of the path}

\item{sem.functions}{A list containing the gam or gamm4 functions that
define the structural equations.  This is normally the sem.functions returned
from pwSEM}

\item{data}{The data frame containing the empirical data used in the SEM functions}

\item{minimum.x}{The minimum value of the "from" variable; defaults to NULL, in
which case the minimum and maximum values of the "from" variable in the
data set are used.}

\item{maximum.x}{The maximum value of the "to" variable; defaults to NULL, in
which case the minimum and maximum values of the "from" variable in the
data set are used.}

\item{scale}{The chosen scale in which to express the results; either "response"
(which uses the original scale of the variable) or "link" (which uses the
scale of the link function for the "to" variable)}

\item{return.values}{A logical value (TRUE returns the values of "from" and an
estimate of the 1st derivative of the function for from-->to)}

\item{dag}{The directed acyclic graph (DAG) used; usually this is the causal.graph
object returned from a call to pwSEM}
}
\value{
Graphs are produced for each directed path from-->to and (return.values=TRUE)
a data frame containing the values of the "from" variable and approxiate values of
the 1st derivative of the function linking from-->to (i.e.the path coefficient)
if the relationship is linear.
}
\description{
This is a function, usually called after pwSEM, to allow you to visually
see how two variables in the DAG relate to each other along all directed paths
from one to the other and to see how the 1st derivative of this relationship
changes as the "from" variable changes.  For linear relationships, this is a
constant (the path coefficient).
}
\examples{
# Example with correlated endogenous errors, Poisson distributed variables
#and no nesting structure in the data
# DAG: X1->X2->X3->X4 and X2<->X4
my.list<-list(mgcv::gam(X1~1,data=sim_poisson.no.nesting,family=gaussian),
         mgcv::gam(X2~X1,data=sim_poisson.no.nesting,family=poisson),
         mgcv::gam(X3~X2,data=sim_poisson.no.nesting,family=poisson),
         mgcv::gam(X4~X3,data=sim_poisson.no.nesting,family=poisson))
out<-pwSEM(sem.functions=my.list,marginalized.latents=list(X4~~X2),
          data=sim_poisson.no.nesting,use.permutations = TRUE,n.perms=10000)
# To see each of the effects of X1 on X4 (only one in this example), we
# use view.paths() while imputing the list of SEM functions (out$sem.functions)
# and the DAG (out$causal.graph) that are output from the pwSEM function.

view.paths(from="X1",to="X4",sem.functions=out$sem.functions,data=
sim_poisson.no.nesting,scale="response",dag=out$causal.graph)

}
