% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AB_t2n.R
\name{AB_t2n}
\alias{AB_t2n}
\title{Two-Sample t-Test Power Analysis}
\usage{
AB_t2n(N = NULL, percent_B = NULL, mean_diff = NULL, sd_A, sd_B,
  sig_level = NULL, power = NULL, alternative = c("two_sided", "less",
  "greater"), max_sample = 1e+07)
}
\arguments{
\item{N}{Total number of observations (sum of observations for groups A and B)}

\item{percent_B}{Percentage of total observations allocated to group B
(between 0 and 1 - e.g. input .5 for 50\%)}

\item{mean_diff}{Difference in means of the two groups, with mean_B - mean_A}

\item{sd_A}{Standard deviation of group A}

\item{sd_B}{Standard deviation of group B}

\item{sig_level}{Significance level (Type I error probability)}

\item{power}{Power of test (1 minus Type II error probability)}

\item{alternative}{Character string specifying the alternative hypothesis,
must be one of "two_sided" (default), "greater" or "less"}

\item{max_sample}{Maximum sample size that is searched for}
}
\value{
Object of class "power.htest", a list of the arguments
(including the computed one).
}
\description{
\code{AB_t2n} performs the power analysis for AB testing. It uses the Welch's t-test,
which allows for the standard deviation to vary across groups.
}
\details{
Exactly one of the parameters 'N', 'percent_B', 'mean_diff', 'sig_level', and 'power'
must be passed as NULL, and the omitted parameter is determined from the others.
sd_A and sd_B must be specified. When 'percent_B' is the parameter omitted, two solutions
may exist, in which case the smaller value will be returned
}
\examples{
# Search for power given other parameters
AB_t2n(N = 3000, percent_B = .3, mean_diff = .15, sd_A = 1,
sd_B = 2, sig_level = .05, alternative = 'two_sided')

# Search for sample size required to satisfy other parameters
AB_t2n(percent_B = .3, mean_diff = .15, sd_A = 1,
sd_B = 2, sig_level = .05, power = .8, alternative = 'two_sided')

}
