% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chaotic_0.1.8.R
\name{Chaotic}
\alias{Chaotic}
\title{Chaotic, a random number generator of q-Gaussian random variables.}
\usage{
Chaotic(n,q,v0,z0)
}
\arguments{
\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{q}{entropic index.}

\item{v0}{a random seed.}

\item{z0}{a random seed.}
}
\value{
a number q < 3, and the standard error.
}
\description{
Given a random number generator of q-Gaussian random variables for a range of q values,
-8 < q < 3, based on deterministic map dynamics. To yield a 'q' value, a characteristic 
               entropic index  of the q-gaussian distributions.
}
\examples{
t=Chaotic(100000,0,.1,.1)
hist(t,breaks=100)
}
\author{
Emerson Luis de Santa Helena , Wagner Santos de Lima
}
\references{
Umeno, K., Sato, A., IEEE Transactions on Information Theory (Volume:59,Issue:5,May 2013).Chaotic Method for Generating q-Gaussian Random Variables. 
}
\seealso{
Distributions for other standard distributions, including dt and dcauchy.
            \code{\link[stats]{Distributions}}
}

