% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_utility.R
\name{.qgcomp_object}
\alias{.qgcomp_object}
\title{Creating a \code{qgcompfit} object}
\usage{
.qgcomp_object(...)
}
\arguments{
\item{...}{named objects to add to the \code{qgcompfit} object}
}
\value{
a \code{qgcompfit} object
}
\description{
\code{.qgcomp_object} developer function to create a \code{qgcompfit} object (a list of class "qgcompfit")
}
\details{
This is not a generally useful function, except for developers, who need to add items to an existing qgcompfit object.
}
\examples{
set.seed(50)
# linear model, adding an arbitrary string to the object
dat <- data.frame(y=runif(50,-1,1), x1=runif(50), x2=runif(50), z=runif(50))
expnms = c('x1')
q=NULL
ft = glm(f=y ~ z + x1 + x2, data=dat, family=gaussian())
z = coef(ft)[2]/sqrt(vcov(ft)[2,2])
pval = (1-pnorm(abs(z)))*2
.qgcomp_object(fit = ft, coef=coef(ft)[2], q=NULL, var.coef = vcov(ft)[2,2], 
ci.coef=coef(ft)[2] + c(-1.96, 1.96)*sqrt(vcov(ft)[2,2]), tstat = z, pval = pval, 
bootstrap=FALSE)
}
